/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.r4;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Basic;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;

@ResourceDef(id="ArtifactAssessment", profile="http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-artifactAssessment")
public class ArtifactAssessment
extends Basic {
    public static final String ARTIFACT_COMMENT_EXTENSION_URL = "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-artifactComment";
    public static final String CONTENT = "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-artifactAssessmentContent";
    public static final String ARTIFACT = "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-artifactAssessmentArtifact";
    public static final String CITEAS = "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-artifactAssessmentCiteAs";
    public static final String TITLE = "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-artifactAssessmentTitle";
    public static final String DATE = "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-artifactAssessmentDate";
    public static final String COPYRIGHT = "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-artifactAssessmentCopyright";
    public static final String APPROVAL_DATE = "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-artifactAssessmentApprovalDate";
    public static final String LAST_REVIEW_DATE = "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-artifactAssessmentLastReviewDate";
    public static final String WORKFLOW_STATUS = "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-artifactAssessmentWorkflowStatus";
    public static final String DISPOSITION = "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-artifactAssessmentDisposition";

    public ArtifactAssessment() {
    }

    public ArtifactAssessment(Reference artifact) {
        this.setArtifactExtension(artifact);
    }

    public ArtifactAssessment(CanonicalType artifact) {
        this.setArtifactExtension(artifact);
    }

    public ArtifactAssessment(UriType artifact) {
        this.setArtifactExtension(artifact);
    }

    public ArtifactAssessment createArtifactComment(CodeType type, Reference targetReference, Optional<CanonicalType> derivedFromUri, Optional<MarkdownType> text, Optional<CanonicalType> reference, Optional<Reference> user) throws FHIRException {
        ArtifactAssessmentContentExtension content = new ArtifactAssessmentContentExtension();
        if (type != null) {
            content.setInfoType(type);
        }
        if (text.isPresent() && !StringUtils.isBlank((CharSequence)((CharSequence)text.get().getValue()))) {
            content.setSummary(text.get());
        }
        if (reference.isPresent() && !StringUtils.isBlank((CharSequence)((CharSequence)reference.get().getValue()))) {
            content.addRelatedArtifact(reference.get(), RelatedArtifact.RelatedArtifactType.CITATION);
        }
        if (user.isPresent() && !StringUtils.isBlank((CharSequence)user.get().getReference())) {
            content.setAuthorExtension(user.get());
        }
        if (derivedFromUri.isPresent() && !StringUtils.isBlank((CharSequence)((CharSequence)derivedFromUri.get().getValue()))) {
            content.addRelatedArtifact(derivedFromUri.get(), RelatedArtifact.RelatedArtifactType.DERIVEDFROM);
        }
        this.addExtension(content);
        this.setDateExtension(new DateTimeType(new Date()));
        if (targetReference != null && !StringUtils.isBlank((CharSequence)targetReference.getReference())) {
            this.setArtifactExtension(targetReference);
        }
        return this;
    }

    public ArtifactAssessment createArtifactComment(CodeType type, CanonicalType targetReference, Optional<CanonicalType> derivedFromUri, Optional<MarkdownType> text, Optional<CanonicalType> reference, Optional<Reference> user) throws FHIRException {
        ArtifactAssessmentContentExtension content = new ArtifactAssessmentContentExtension();
        if (type != null) {
            content.setInfoType(type);
        }
        if (text.isPresent() && !StringUtils.isBlank((CharSequence)((CharSequence)text.get().getValue()))) {
            content.setSummary(text.get());
        }
        if (reference.isPresent() && !StringUtils.isBlank((CharSequence)((CharSequence)reference.get().getValue()))) {
            content.addRelatedArtifact(reference.get(), RelatedArtifact.RelatedArtifactType.CITATION);
        }
        if (user.isPresent() && !StringUtils.isBlank((CharSequence)user.get().getReference())) {
            content.setAuthorExtension(user.get());
        }
        if (derivedFromUri.isPresent() && !StringUtils.isBlank((CharSequence)((CharSequence)derivedFromUri.get().getValue()))) {
            content.addRelatedArtifact(derivedFromUri.get(), RelatedArtifact.RelatedArtifactType.DERIVEDFROM);
        }
        this.addExtension(content);
        this.setDateExtension(new DateTimeType(new Date()));
        if (targetReference != null && !StringUtils.isBlank((CharSequence)((CharSequence)targetReference.getValue()))) {
            this.setArtifactExtension(targetReference);
        }
        return this;
    }

    public ArtifactAssessment createArtifactComment(CodeType type, UriType targetReference, Optional<CanonicalType> derivedFromUri, Optional<MarkdownType> text, Optional<CanonicalType> reference, Optional<Reference> user) throws FHIRException {
        ArtifactAssessmentContentExtension content = new ArtifactAssessmentContentExtension();
        if (type != null) {
            content.setInfoType(type);
        }
        if (text.isPresent() && !StringUtils.isBlank((CharSequence)((CharSequence)text.get().getValue()))) {
            content.setSummary(text.get());
        }
        if (reference.isPresent() && !StringUtils.isBlank((CharSequence)((CharSequence)reference.get().getValue()))) {
            content.addRelatedArtifact(reference.get(), RelatedArtifact.RelatedArtifactType.CITATION);
        }
        if (user.isPresent() && !StringUtils.isBlank((CharSequence)user.get().getReference())) {
            content.setAuthorExtension(user.get());
        }
        if (derivedFromUri.isPresent() && !StringUtils.isBlank((CharSequence)((CharSequence)derivedFromUri.get().getValue()))) {
            content.addRelatedArtifact(derivedFromUri.get(), RelatedArtifact.RelatedArtifactType.DERIVEDFROM);
        }
        this.addExtension(content);
        this.setDateExtension(new DateTimeType(new Date()));
        if (targetReference != null && !StringUtils.isBlank((CharSequence)((CharSequence)targetReference.getValue()))) {
            this.setArtifactExtension(targetReference);
        }
        return this;
    }

    public Optional<RelatedArtifact> getDerivedFromContentRelatedArtifact() {
        Optional<Extension> maybeRelatedArtifact;
        Optional<RelatedArtifact> returnedRelatedArtifact = Optional.empty();
        Optional<Extension> content = Optional.ofNullable(this.getExtensionByUrl(CONTENT));
        if (content.isPresent() && (maybeRelatedArtifact = content.get().getExtension().stream().filter(extension -> extension.getUrl().equals("relatedArtifact") && ((RelatedArtifact)extension.getValue()).getType().equals((Object)RelatedArtifact.RelatedArtifactType.DERIVEDFROM)).findFirst()).isPresent()) {
            RelatedArtifact derivedFromArtifact = (RelatedArtifact)maybeRelatedArtifact.get().getValue();
            returnedRelatedArtifact = Optional.of(derivedFromArtifact);
        }
        return returnedRelatedArtifact;
    }

    public ArtifactAssessment setDerivedFromContentRelatedArtifact(CanonicalType targetUri) {
        Optional<RelatedArtifact> existingRelatedArtifact = this.getDerivedFromContentRelatedArtifact();
        if (existingRelatedArtifact.isPresent()) {
            RelatedArtifact derivedFromArtifact = existingRelatedArtifact.get();
            derivedFromArtifact.setResourceElement(targetUri);
        } else {
            Extension content = this.getExtensionByUrl(CONTENT);
            if (content == null) {
                content = new Extension(CONTENT);
                this.addExtension(content);
            }
            RelatedArtifact newRelatedArtifact = new RelatedArtifact();
            newRelatedArtifact.setType(RelatedArtifact.RelatedArtifactType.DERIVEDFROM);
            newRelatedArtifact.setResourceElement(targetUri);
            content.addExtension("relatedArtifact", (Type)newRelatedArtifact);
        }
        return this;
    }

    public ArtifactAssessment setDerivedFromContentRelatedArtifact(String targetUri) {
        return this.setDerivedFromContentRelatedArtifact(new CanonicalType(targetUri));
    }

    public boolean checkArtifactCommentParams(String artifactAssessmentType, String artifactAssessmentSummary, String artifactAssessmentTargetReference, String artifactAssessmentRelatedArtifact, String derivedFromRelatedArtifactUrl, String artifactAssessmentAuthor) {
        int artifactIndex;
        boolean infoTypeCorrect = false;
        boolean summaryCorrect = false;
        boolean citationRelatedArtifactCorrect = false;
        boolean derivedFromRelatedArtifactCorrect = false;
        boolean authorCorrect = false;
        boolean artifactCorrect = false;
        int contentIndex = this.findIndex(CONTENT, null, this.getExtension());
        if (contentIndex != -1) {
            int authorIndex;
            List relatedArtifactList;
            int summaryIndex;
            Extension contentExt = (Extension)this.getExtension().get(contentIndex);
            int infoTypeIndex = this.findIndex("informationType", null, contentExt.getExtension());
            if (infoTypeIndex != -1) {
                Extension infoTypeExt = (Extension)contentExt.getExtension().get(infoTypeIndex);
                infoTypeCorrect = ((CodeType)infoTypeExt.getValue()).getCode().equals(artifactAssessmentType);
            }
            if ((summaryIndex = this.findIndex("summary", null, contentExt.getExtension())) != -1) {
                Extension summaryExt = (Extension)contentExt.getExtension().get(summaryIndex);
                summaryCorrect = ((String)((StringType)summaryExt.getValue()).getValue()).equals(artifactAssessmentSummary);
            }
            if ((relatedArtifactList = contentExt.getExtension().stream().filter(e -> e.getUrl().equals("relatedArtifact")).collect(Collectors.toList())).size() > 0) {
                Optional<Extension> maybeCitation = relatedArtifactList.stream().filter(ext -> ((RelatedArtifact)ext.getValue()).getType().equals((Object)RelatedArtifact.RelatedArtifactType.CITATION)).findAny();
                Optional<Extension> maybeDerivedFrom = relatedArtifactList.stream().filter(ext -> ((RelatedArtifact)ext.getValue()).getType().equals((Object)RelatedArtifact.RelatedArtifactType.DERIVEDFROM)).findAny();
                if (maybeCitation.isPresent()) {
                    Extension citation = maybeCitation.get();
                    citationRelatedArtifactCorrect = ((RelatedArtifact)citation.getValue()).getResource().equals(artifactAssessmentRelatedArtifact);
                }
                if (maybeDerivedFrom.isPresent()) {
                    Extension derivedFrom = maybeDerivedFrom.get();
                    derivedFromRelatedArtifactCorrect = ((RelatedArtifact)derivedFrom.getValue()).getResource().equals(derivedFromRelatedArtifactUrl);
                }
            }
            if ((authorIndex = this.findIndex("author", null, contentExt.getExtension())) != -1) {
                Extension authorExt = (Extension)contentExt.getExtension().get(authorIndex);
                authorCorrect = ((Reference)authorExt.getValue()).getReference().equals(artifactAssessmentAuthor);
            }
        }
        if ((artifactIndex = this.findIndex(ARTIFACT, null, this.getExtension())) != -1) {
            Extension artifactExt = (Extension)this.getExtension().get(artifactIndex);
            artifactCorrect = ((Reference)artifactExt.getValue()).getReference().equals(artifactAssessmentTargetReference);
        }
        return artifactCorrect && infoTypeCorrect && summaryCorrect && citationRelatedArtifactCorrect && derivedFromRelatedArtifactCorrect && authorCorrect;
    }

    public boolean isValidArtifactComment() {
        boolean infoTypeExists = false;
        boolean summaryExists = false;
        boolean relatedArtifactExists = false;
        boolean authorExists = false;
        boolean dateExists = this.findIndex(DATE, null, this.getExtension()) != -1;
        boolean artifactExists = this.findIndex(ARTIFACT, null, this.getExtension()) != -1;
        int contentIndex = this.findIndex(CONTENT, null, this.getExtension());
        if (contentIndex != -1) {
            Extension content = (Extension)this.getExtension().get(contentIndex);
            infoTypeExists = this.findIndex("informationType", null, content.getExtension()) != -1;
            summaryExists = this.findIndex("summary", null, content.getExtension()) != -1;
            relatedArtifactExists = this.findIndex("relatedArtifact", null, content.getExtension()) != -1;
            authorExists = this.findIndex("author", null, content.getExtension()) != -1;
        }
        return (infoTypeExists || summaryExists || relatedArtifactExists || authorExists) && dateExists && artifactExists;
    }

    List<ArtifactAssessmentContentExtension> getContent() {
        return this.getExtension().stream().filter(ext -> ext.getUrl().equals(CONTENT)).map(ext -> (ArtifactAssessmentContentExtension)((Object)ext)).collect(Collectors.toList());
    }

    public ArtifactAssessment setArtifactExtension(CanonicalType target) {
        if (target != null && target.getValue() != null) {
            int index = this.findIndex(ARTIFACT, null, this.getExtension());
            if (index != -1) {
                this.extension.set(index, new ArtifactAssessmentArtifactExtension(target));
            } else {
                this.addExtension(new ArtifactAssessmentArtifactExtension(target));
            }
        }
        return this;
    }

    public ArtifactAssessment setArtifactExtension(Reference target) {
        if (target != null && target.getReference() != null) {
            int index = this.findIndex(ARTIFACT, null, this.getExtension());
            if (index != -1) {
                this.extension.set(index, new ArtifactAssessmentArtifactExtension(target));
            } else {
                this.addExtension(new ArtifactAssessmentArtifactExtension(target));
            }
        }
        return this;
    }

    public ArtifactAssessment setArtifactExtension(UriType target) {
        if (target != null && target.getValue() != null) {
            int index = this.findIndex(ARTIFACT, null, this.getExtension());
            if (index != -1) {
                this.extension.set(index, new ArtifactAssessmentArtifactExtension(target));
            } else {
                this.addExtension(new ArtifactAssessmentArtifactExtension(target));
            }
        }
        return this;
    }

    public ArtifactAssessment setDateExtension(DateTimeType date) {
        if (date != null) {
            int index = this.findIndex(DATE, null, this.getExtension());
            if (index != -1) {
                this.extension.set(index, new ArtifactAssessmentDateExtension(date));
            } else {
                this.addExtension(new ArtifactAssessmentDateExtension(date));
            }
        }
        return this;
    }

    public ArtifactAssessment setLastReviewDateExtension(DateType reviewDate) {
        if (reviewDate != null) {
            int index = this.findIndex(LAST_REVIEW_DATE, null, this.getExtension());
            if (index != -1) {
                this.extension.set(index, new ArtifactAssessmentLastReviewDateExtension(reviewDate));
            } else {
                this.addExtension(new ArtifactAssessmentLastReviewDateExtension(reviewDate));
            }
        }
        return this;
    }

    public ArtifactAssessment setApprovalDateExtension(DateType approvalDate) {
        if (approvalDate != null) {
            int index = this.findIndex(APPROVAL_DATE, null, this.getExtension());
            if (index != -1) {
                this.extension.set(index, new ArtifactAssessmentApprovalDateExtension(approvalDate));
            } else {
                this.addExtension(new ArtifactAssessmentApprovalDateExtension(approvalDate));
            }
        }
        return this;
    }

    public ArtifactAssessment setTitleExtension(MarkdownType title) {
        if (title != null) {
            int index = this.findIndex(TITLE, null, this.getExtension());
            if (index != -1) {
                this.extension.set(index, new ArtifactAssessmentTitleExtension((StringType)title));
            } else {
                this.addExtension(new ArtifactAssessmentTitleExtension((StringType)title));
            }
        }
        return this;
    }

    public ArtifactAssessment setCopyrightExtension(MarkdownType copyright) {
        if (copyright != null) {
            int index = this.findIndex(COPYRIGHT, null, this.getExtension());
            if (index != -1) {
                this.extension.set(index, new ArtifactAssessmentCopyrightExtension(copyright));
            } else {
                this.addExtension(new ArtifactAssessmentCopyrightExtension(copyright));
            }
        }
        return this;
    }

    public ArtifactAssessment setCiteAsExtension(MarkdownType citeAs) {
        if (citeAs != null) {
            int index = this.findIndex(CITEAS, null, this.getExtension());
            if (index != -1) {
                this.extension.set(index, new ArtifactAssessmentCiteAsExtension(citeAs));
            } else {
                this.addExtension(new ArtifactAssessmentCiteAsExtension(citeAs));
            }
        }
        return this;
    }

    public ArtifactAssessment setCiteAsExtension(Reference citeAs) {
        if (citeAs != null) {
            int index = this.findIndex(CITEAS, null, this.getExtension());
            if (index != -1) {
                this.extension.set(index, new ArtifactAssessmentCiteAsExtension(citeAs));
            } else {
                this.addExtension(new ArtifactAssessmentCiteAsExtension(citeAs));
            }
        }
        return this;
    }

    public ArtifactAssessment setArtifactAssessmentWorkflowStatusExtension(Enumeration<ArtifactAssessmentWorkflowStatus> status) {
        if (status != null) {
            int index = this.findIndex(WORKFLOW_STATUS, null, this.getExtension());
            if (index != -1) {
                this.extension.set(index, new ArtifactAssessmentWorkflowStatusExtension(status));
            } else {
                this.addExtension(new ArtifactAssessmentWorkflowStatusExtension(status));
            }
        }
        return this;
    }

    public ArtifactAssessment setArtifactAssessmentDispositionExtension(Enumeration<ArtifactAssessmentDisposition> status) {
        if (status != null) {
            int index = this.findIndex(DISPOSITION, null, this.getExtension());
            if (index != -1) {
                this.extension.set(index, new ArtifactAssessmentDispositionExtension(status));
            } else {
                this.addExtension(new ArtifactAssessmentDispositionExtension(status));
            }
        }
        return this;
    }

    private int findIndex(String url, Type value, List<Extension> extensions) {
        Optional<Extension> existingExtension = value != null ? extensions.stream().filter(e -> e.getUrl().equals(url) && e.getValue().equals(value)).findAny() : extensions.stream().filter(e -> e.getUrl().equals(url)).findAny();
        if (existingExtension.isPresent()) {
            return extensions.indexOf(existingExtension.get());
        }
        return -1;
    }

    @DatatypeDef(name="ArtifactAssessmentContentExtension", isSpecialization=true, profileOf=Extension.class)
    public class ArtifactAssessmentContentExtension
    extends Extension {
        public static final String INFOTYPE = "informationType";
        public static final String SUMMARY = "summary";
        public static final String TYPE = "type";
        public static final String CLASSIFIER = "classifier";
        public static final String QUANTITY = "quantity";
        public static final String AUTHOR = "author";
        public static final String PATH = "path";
        public static final String RELATEDARTIFACT = "relatedArtifact";
        public static final String FREETOSHARE = "freeToShare";
        public static final String COMPONENT = "component";

        public ArtifactAssessmentContentExtension() throws FHIRException {
            super(ArtifactAssessment.CONTENT);
        }

        ArtifactAssessmentContentExtension setInfoType(CodeType infoType) throws FHIRException {
            if (infoType != null) {
                int index = ArtifactAssessment.this.findIndex(INFOTYPE, null, this.getExtension());
                if (index != -1) {
                    this.extension.set(index, new ArtifactAssessmentContentInformationTypeExtension(infoType));
                } else {
                    this.addExtension(new ArtifactAssessmentContentInformationTypeExtension(infoType));
                }
            }
            return this;
        }

        ArtifactAssessmentContentExtension setSummary(MarkdownType summary) {
            if (summary != null) {
                int index = ArtifactAssessment.this.findIndex(SUMMARY, null, this.getExtension());
                if (index != -1) {
                    this.extension.set(index, new ArtifactAssessmentContentSummaryExtension(summary));
                } else {
                    this.addExtension(new ArtifactAssessmentContentSummaryExtension(summary));
                }
            }
            return this;
        }

        ArtifactAssessmentContentExtension addRelatedArtifact(CanonicalType reference, RelatedArtifact.RelatedArtifactType type) {
            if (reference != null) {
                RelatedArtifact newRelatedArtifact = new RelatedArtifact();
                newRelatedArtifact.setType(type);
                newRelatedArtifact.setResourceElement(reference);
                int index = ArtifactAssessment.this.findIndex(RELATEDARTIFACT, (Type)newRelatedArtifact, this.getExtension());
                if (index == -1) {
                    this.addExtension(new ArtifactAssessmentContentRelatedArtifactExtension(newRelatedArtifact));
                }
            }
            return this;
        }

        ArtifactAssessmentContentExtension addComponent(ArtifactAssessmentContentExtension component) {
            if (component != null) {
                this.addExtension(new ArtifactAssessmentContentComponentExtension(component));
            }
            return this;
        }

        ArtifactAssessmentContentExtension setAuthorExtension(Reference author) {
            if (author != null) {
                int index = ArtifactAssessment.this.findIndex(AUTHOR, null, this.getExtension());
                if (index != -1) {
                    this.extension.set(index, new ArtifactAssessmentContentAuthorExtension(author));
                } else {
                    this.addExtension(new ArtifactAssessmentContentAuthorExtension(author));
                }
            }
            return this;
        }

        ArtifactAssessmentContentExtension setQuantityExtension(Quantity quantity) {
            if (quantity != null) {
                int index = ArtifactAssessment.this.findIndex(QUANTITY, null, this.getExtension());
                if (index != -1) {
                    this.extension.set(index, new ArtifactAssessmentContentQuantityExtension(quantity));
                } else {
                    this.addExtension(new ArtifactAssessmentContentQuantityExtension(quantity));
                }
            }
            return this;
        }

        ArtifactAssessmentContentExtension setTypeExtension(CodeableConcept type) {
            if (type != null) {
                int index = ArtifactAssessment.this.findIndex(TYPE, null, this.getExtension());
                if (index != -1) {
                    this.extension.set(index, new ArtifactAssessmentContentTypeExtension(type));
                } else {
                    this.addExtension(new ArtifactAssessmentContentTypeExtension(type));
                }
            }
            return this;
        }

        ArtifactAssessmentContentExtension setFreeToShareExtension(BooleanType freeToShare) {
            if (freeToShare != null) {
                int index = ArtifactAssessment.this.findIndex(FREETOSHARE, null, this.getExtension());
                if (index != -1) {
                    this.extension.set(index, new ArtifactAssessmentContentFreeToShareExtension(freeToShare));
                } else {
                    this.addExtension(new ArtifactAssessmentContentFreeToShareExtension(freeToShare));
                }
            }
            return this;
        }

        ArtifactAssessmentContentExtension addClassifierExtension(CodeableConcept classifier) {
            int index;
            if (classifier != null && (index = ArtifactAssessment.this.findIndex(CLASSIFIER, (Type)classifier, this.getExtension())) == -1) {
                this.addExtension(new ArtifactAssessmentContentClassifierExtension(classifier));
            }
            return this;
        }

        ArtifactAssessmentContentExtension addPathExtension(UriType path) {
            int index;
            if (path != null && (index = ArtifactAssessment.this.findIndex(PATH, (Type)path, this.getExtension())) == -1) {
                this.addExtension(new ArtifactAssessmentContentPathExtension(path));
            }
            return this;
        }

        @DatatypeDef(name="ArtifactAssessmentContentInformationTypeExtension", isSpecialization=true, profileOf=Extension.class)
        private class ArtifactAssessmentContentInformationTypeExtension
        extends Extension {
            public ArtifactAssessmentContentInformationTypeExtension(CodeType informationTypeCode) {
                super(ArtifactAssessmentContentExtension.INFOTYPE);
                ArtifactAssessmentContentInformationType.fromCode((String)informationTypeCode.getValue());
                this.setValue((Type)informationTypeCode);
            }
        }

        @DatatypeDef(name="ArtifactAssessmentContentSummaryExtension", isSpecialization=true, profileOf=Extension.class)
        private class ArtifactAssessmentContentSummaryExtension
        extends Extension {
            public ArtifactAssessmentContentSummaryExtension(MarkdownType summary) {
                super(ArtifactAssessmentContentExtension.SUMMARY, (IBaseDatatype)summary);
            }
        }

        @DatatypeDef(name="ArtifactAssessmentContentRelatedArtifactExtension", isSpecialization=true, profileOf=Extension.class)
        private class ArtifactAssessmentContentRelatedArtifactExtension
        extends Extension {
            public ArtifactAssessmentContentRelatedArtifactExtension(RelatedArtifact relatedArtifact) {
                super(ArtifactAssessmentContentExtension.RELATEDARTIFACT, (IBaseDatatype)relatedArtifact);
            }
        }

        @DatatypeDef(name="ArtifactAssessmentContentComponentExtension", isSpecialization=true, profileOf=Extension.class)
        private class ArtifactAssessmentContentComponentExtension
        extends Extension {
            public ArtifactAssessmentContentComponentExtension(ArtifactAssessmentContentExtension contentExtension) {
                super(ArtifactAssessmentContentExtension.COMPONENT, (IBaseDatatype)contentExtension);
            }
        }

        @DatatypeDef(name="ArtifactAssessmentContentAuthorExtension", isSpecialization=true, profileOf=Extension.class)
        private class ArtifactAssessmentContentAuthorExtension
        extends Extension {
            public ArtifactAssessmentContentAuthorExtension(Reference author) {
                super(ArtifactAssessmentContentExtension.AUTHOR, (IBaseDatatype)author);
            }
        }

        @DatatypeDef(name="ArtifactAssessmentContentQuantityExtension", isSpecialization=true, profileOf=Extension.class)
        private class ArtifactAssessmentContentQuantityExtension
        extends Extension {
            public ArtifactAssessmentContentQuantityExtension(Quantity quantity) {
                super(ArtifactAssessmentContentExtension.QUANTITY, (IBaseDatatype)quantity);
            }
        }

        @DatatypeDef(name="ArtifactAssessmentContentTypeExtension", isSpecialization=true, profileOf=Extension.class)
        private class ArtifactAssessmentContentTypeExtension
        extends Extension {
            @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-type")
            protected CodeableConcept value;

            public ArtifactAssessmentContentTypeExtension(CodeableConcept typeConcept) {
                super(ArtifactAssessmentContentExtension.TYPE, (IBaseDatatype)typeConcept);
            }
        }

        @DatatypeDef(name="ArtifactAssessmentContentFreeToShareExtension", isSpecialization=true, profileOf=Extension.class)
        private class ArtifactAssessmentContentFreeToShareExtension
        extends Extension {
            public ArtifactAssessmentContentFreeToShareExtension(BooleanType freeToShare) {
                super(ArtifactAssessmentContentExtension.FREETOSHARE, (IBaseDatatype)freeToShare);
            }
        }

        @DatatypeDef(name="ArtifactAssessmentContentClassifierExtension", isSpecialization=true, profileOf=Extension.class)
        private class ArtifactAssessmentContentClassifierExtension
        extends Extension {
            @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-rating")
            protected CodeableConcept value;

            public ArtifactAssessmentContentClassifierExtension(CodeableConcept classifierConcept) {
                super(ArtifactAssessmentContentExtension.CLASSIFIER, (IBaseDatatype)classifierConcept);
            }
        }

        @DatatypeDef(name="ArtifactAssessmentContentPathExtension", isSpecialization=true, profileOf=Extension.class)
        private class ArtifactAssessmentContentPathExtension
        extends Extension {
            public ArtifactAssessmentContentPathExtension(UriType path) {
                super(ArtifactAssessmentContentExtension.PATH, (IBaseDatatype)path);
            }
        }
    }

    @DatatypeDef(name="ArtifactAssessmentArtifactExtension", isSpecialization=true, profileOf=Extension.class)
    private class ArtifactAssessmentArtifactExtension
    extends Extension {
        public ArtifactAssessmentArtifactExtension(CanonicalType target) {
            super(ArtifactAssessment.ARTIFACT, (IBaseDatatype)target);
        }

        public ArtifactAssessmentArtifactExtension(Reference target) {
            super(ArtifactAssessment.ARTIFACT, (IBaseDatatype)target);
        }

        public ArtifactAssessmentArtifactExtension(UriType target) {
            super(ArtifactAssessment.ARTIFACT, (IBaseDatatype)target);
        }
    }

    @DatatypeDef(name="ArtifactAssessmentDateExtension", isSpecialization=true, profileOf=Extension.class)
    private class ArtifactAssessmentDateExtension
    extends Extension {
        public ArtifactAssessmentDateExtension(DateTimeType date) {
            super(ArtifactAssessment.DATE, (IBaseDatatype)date);
        }
    }

    @DatatypeDef(name="ArtifactAssessmentLastReviewDateExtension", isSpecialization=true, profileOf=Extension.class)
    private class ArtifactAssessmentLastReviewDateExtension
    extends Extension {
        public ArtifactAssessmentLastReviewDateExtension(DateType lastReviewDate) {
            super(ArtifactAssessment.LAST_REVIEW_DATE, (IBaseDatatype)lastReviewDate);
        }
    }

    @DatatypeDef(name="ArtifactAssessmentApprovalDateExtension", isSpecialization=true, profileOf=Extension.class)
    private class ArtifactAssessmentApprovalDateExtension
    extends Extension {
        public ArtifactAssessmentApprovalDateExtension(DateType approvalDate) {
            super(ArtifactAssessment.APPROVAL_DATE, (IBaseDatatype)approvalDate);
        }
    }

    @DatatypeDef(name="ArtifactAssessmentTitleExtension", isSpecialization=true, profileOf=Extension.class)
    private class ArtifactAssessmentTitleExtension
    extends Extension {
        public ArtifactAssessmentTitleExtension(StringType title) {
            super(ArtifactAssessment.TITLE, (IBaseDatatype)title);
        }
    }

    @DatatypeDef(name="ArtifactAssessmentCopyrightExtension", isSpecialization=true, profileOf=Extension.class)
    private class ArtifactAssessmentCopyrightExtension
    extends Extension {
        public ArtifactAssessmentCopyrightExtension(MarkdownType copyright) {
            super(ArtifactAssessment.COPYRIGHT, (IBaseDatatype)copyright);
        }
    }

    @DatatypeDef(name="ArtifactAssessmentCiteAsExtension", isSpecialization=true, profileOf=Extension.class)
    private class ArtifactAssessmentCiteAsExtension
    extends Extension {
        public ArtifactAssessmentCiteAsExtension(Reference citation) {
            super(ArtifactAssessment.CITEAS, (IBaseDatatype)citation);
        }

        public ArtifactAssessmentCiteAsExtension(MarkdownType citation) {
            super(ArtifactAssessment.CITEAS, (IBaseDatatype)citation);
        }
    }

    @DatatypeDef(name="ArtifactAssessmentWorkflowStatusExtension", isSpecialization=true, profileOf=Extension.class)
    private class ArtifactAssessmentWorkflowStatusExtension
    extends Extension {
        public ArtifactAssessmentWorkflowStatusExtension(Enumeration<ArtifactAssessmentWorkflowStatus> status) {
            super(ArtifactAssessment.WORKFLOW_STATUS, status);
        }
    }

    @DatatypeDef(name="ArtifactAssessmentDispositionExtension", isSpecialization=true, profileOf=Extension.class)
    private class ArtifactAssessmentDispositionExtension
    extends Extension {
        public ArtifactAssessmentDispositionExtension(Enumeration<ArtifactAssessmentDisposition> disposition) {
            super(ArtifactAssessment.DISPOSITION, disposition);
        }
    }

    public static class ArtifactAssessmentDispositionEnumFactory
    implements EnumFactory<ArtifactAssessmentDisposition> {
        public ArtifactAssessmentDisposition fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("unresolved".equals(codeString)) {
                return ArtifactAssessmentDisposition.UNRESOLVED;
            }
            if ("not-persuasive".equals(codeString)) {
                return ArtifactAssessmentDisposition.NOTPERSUASIVE;
            }
            if ("persuasive".equals(codeString)) {
                return ArtifactAssessmentDisposition.PERSUASIVE;
            }
            if ("persuasive-with-modification".equals(codeString)) {
                return ArtifactAssessmentDisposition.PERSUASIVEWITHMODIFICATION;
            }
            if ("not-persuasive-with-modification".equals(codeString)) {
                return ArtifactAssessmentDisposition.NOTPERSUASIVEWITHMODIFICATION;
            }
            throw new IllegalArgumentException("Unknown ArtifactAssessmentDisposition code '" + codeString + "'");
        }

        public Enumeration<ArtifactAssessmentDisposition> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration((EnumFactory)this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("unresolved".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentDisposition.UNRESOLVED);
            }
            if ("not-persuasive".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentDisposition.NOTPERSUASIVE);
            }
            if ("persuasive".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentDisposition.PERSUASIVE);
            }
            if ("persuasive-with-modification".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentDisposition.PERSUASIVEWITHMODIFICATION);
            }
            if ("not-persuasive-with-modification".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentDisposition.NOTPERSUASIVEWITHMODIFICATION);
            }
            throw new FHIRException("Unknown ArtifactAssessmentDisposition code '" + codeString + "'");
        }

        public String toCode(ArtifactAssessmentDisposition code) {
            if (code == ArtifactAssessmentDisposition.UNRESOLVED) {
                return "unresolved";
            }
            if (code == ArtifactAssessmentDisposition.NOTPERSUASIVE) {
                return "not-persuasive";
            }
            if (code == ArtifactAssessmentDisposition.PERSUASIVE) {
                return "persuasive";
            }
            if (code == ArtifactAssessmentDisposition.PERSUASIVEWITHMODIFICATION) {
                return "persuasive-with-modification";
            }
            if (code == ArtifactAssessmentDisposition.NOTPERSUASIVEWITHMODIFICATION) {
                return "not-persuasive-with-modification";
            }
            return "?";
        }

        public String toSystem(ArtifactAssessmentDisposition code) {
            return code.getSystem();
        }
    }

    public static enum ArtifactAssessmentDisposition {
        UNRESOLVED,
        NOTPERSUASIVE,
        PERSUASIVE,
        PERSUASIVEWITHMODIFICATION,
        NOTPERSUASIVEWITHMODIFICATION,
        NULL;


        public static ArtifactAssessmentDisposition fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("unresolved".equals(codeString)) {
                return UNRESOLVED;
            }
            if ("not-persuasive".equals(codeString)) {
                return NOTPERSUASIVE;
            }
            if ("persuasive".equals(codeString)) {
                return PERSUASIVE;
            }
            if ("persuasive-with-modification".equals(codeString)) {
                return PERSUASIVEWITHMODIFICATION;
            }
            if ("not-persuasive-with-modification".equals(codeString)) {
                return NOTPERSUASIVEWITHMODIFICATION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ArtifactAssessmentDisposition code '" + codeString + "'");
        }

        public String toCode() {
            switch (this.ordinal()) {
                case 0: {
                    return "unresolved";
                }
                case 1: {
                    return "not-persuasive";
                }
                case 2: {
                    return "persuasive";
                }
                case 3: {
                    return "persuasive-with-modification";
                }
                case 4: {
                    return "not-persuasive-with-modification";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this.ordinal()) {
                case 0: {
                    return "http://hl7.org/fhir/artifactassessment-disposition";
                }
                case 1: {
                    return "http://hl7.org/fhir/artifactassessment-disposition";
                }
                case 2: {
                    return "http://hl7.org/fhir/artifactassessment-disposition";
                }
                case 3: {
                    return "http://hl7.org/fhir/artifactassessment-disposition";
                }
                case 4: {
                    return "http://hl7.org/fhir/artifactassessment-disposition";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this.ordinal()) {
                case 0: {
                    return "The comment is unresolved";
                }
                case 1: {
                    return "The comment is not persuasive (rejected in full)";
                }
                case 2: {
                    return "The comment is persuasive (accepted in full)";
                }
                case 3: {
                    return "The comment is persuasive with modification (partially accepted)";
                }
                case 4: {
                    return "The comment is not persuasive with modification (partially rejected)";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this.ordinal()) {
                case 0: {
                    return "Unresolved";
                }
                case 1: {
                    return "Not Persuasive";
                }
                case 2: {
                    return "Persuasive";
                }
                case 3: {
                    return "Persuasive with Modification";
                }
                case 4: {
                    return "Not Persuasive with Modification";
                }
            }
            return "?";
        }
    }

    public static class ArtifactAssessmentWorkflowStatusEnumFactory
    implements EnumFactory<ArtifactAssessmentWorkflowStatus> {
        public ArtifactAssessmentWorkflowStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("submitted".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.SUBMITTED;
            }
            if ("triaged".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.TRIAGED;
            }
            if ("waiting-for-input".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.WAITINGFORINPUT;
            }
            if ("resolved-no-change".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.RESOLVEDNOCHANGE;
            }
            if ("resolved-change-required".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.RESOLVEDCHANGEREQUIRED;
            }
            if ("deferred".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.DEFERRED;
            }
            if ("duplicate".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.DUPLICATE;
            }
            if ("applied".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.APPLIED;
            }
            if ("published".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.PUBLISHED;
            }
            throw new IllegalArgumentException("Unknown ArtifactAssessmentWorkflowStatus code '" + codeString + "'");
        }

        public Enumeration<ArtifactAssessmentWorkflowStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration((EnumFactory)this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("submitted".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentWorkflowStatus.SUBMITTED);
            }
            if ("triaged".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentWorkflowStatus.TRIAGED);
            }
            if ("waiting-for-input".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentWorkflowStatus.WAITINGFORINPUT);
            }
            if ("resolved-no-change".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentWorkflowStatus.RESOLVEDNOCHANGE);
            }
            if ("resolved-change-required".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentWorkflowStatus.RESOLVEDCHANGEREQUIRED);
            }
            if ("deferred".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentWorkflowStatus.DEFERRED);
            }
            if ("duplicate".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentWorkflowStatus.DUPLICATE);
            }
            if ("applied".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentWorkflowStatus.APPLIED);
            }
            if ("published".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentWorkflowStatus.PUBLISHED);
            }
            throw new FHIRException("Unknown ArtifactAssessmentWorkflowStatus code '" + codeString + "'");
        }

        public String toCode(ArtifactAssessmentWorkflowStatus code) {
            if (code == ArtifactAssessmentWorkflowStatus.SUBMITTED) {
                return "submitted";
            }
            if (code == ArtifactAssessmentWorkflowStatus.TRIAGED) {
                return "triaged";
            }
            if (code == ArtifactAssessmentWorkflowStatus.WAITINGFORINPUT) {
                return "waiting-for-input";
            }
            if (code == ArtifactAssessmentWorkflowStatus.RESOLVEDNOCHANGE) {
                return "resolved-no-change";
            }
            if (code == ArtifactAssessmentWorkflowStatus.RESOLVEDCHANGEREQUIRED) {
                return "resolved-change-required";
            }
            if (code == ArtifactAssessmentWorkflowStatus.DEFERRED) {
                return "deferred";
            }
            if (code == ArtifactAssessmentWorkflowStatus.DUPLICATE) {
                return "duplicate";
            }
            if (code == ArtifactAssessmentWorkflowStatus.APPLIED) {
                return "applied";
            }
            if (code == ArtifactAssessmentWorkflowStatus.PUBLISHED) {
                return "published";
            }
            return "?";
        }

        public String toSystem(ArtifactAssessmentWorkflowStatus code) {
            return code.getSystem();
        }
    }

    public static enum ArtifactAssessmentWorkflowStatus {
        SUBMITTED,
        TRIAGED,
        WAITINGFORINPUT,
        RESOLVEDNOCHANGE,
        RESOLVEDCHANGEREQUIRED,
        DEFERRED,
        DUPLICATE,
        APPLIED,
        PUBLISHED,
        NULL;


        public static ArtifactAssessmentWorkflowStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("submitted".equals(codeString)) {
                return SUBMITTED;
            }
            if ("triaged".equals(codeString)) {
                return TRIAGED;
            }
            if ("waiting-for-input".equals(codeString)) {
                return WAITINGFORINPUT;
            }
            if ("resolved-no-change".equals(codeString)) {
                return RESOLVEDNOCHANGE;
            }
            if ("resolved-change-required".equals(codeString)) {
                return RESOLVEDCHANGEREQUIRED;
            }
            if ("deferred".equals(codeString)) {
                return DEFERRED;
            }
            if ("duplicate".equals(codeString)) {
                return DUPLICATE;
            }
            if ("applied".equals(codeString)) {
                return APPLIED;
            }
            if ("published".equals(codeString)) {
                return PUBLISHED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ArtifactAssessmentWorkflowStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this.ordinal()) {
                case 0: {
                    return "submitted";
                }
                case 1: {
                    return "triaged";
                }
                case 2: {
                    return "waiting-for-input";
                }
                case 3: {
                    return "resolved-no-change";
                }
                case 4: {
                    return "resolved-change-required";
                }
                case 5: {
                    return "deferred";
                }
                case 6: {
                    return "duplicate";
                }
                case 7: {
                    return "applied";
                }
                case 8: {
                    return "published";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this.ordinal()) {
                case 0: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case 1: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case 2: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case 3: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case 4: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case 5: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case 6: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case 7: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case 8: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this.ordinal()) {
                case 0: {
                    return "The comment has been submitted, but the responsible party has not yet been determined, or the responsible party has not yet determined the next steps to be taken.";
                }
                case 1: {
                    return "The comment has been triaged, meaning the responsible party has been determined and next steps have been identified to address the comment.";
                }
                case 2: {
                    return "The comment is waiting for input from a specific party before next steps can be taken.";
                }
                case 3: {
                    return "The comment has been resolved and no changes resulted from the resolution";
                }
                case 4: {
                    return "The comment has been resolved and changes are required to address the comment";
                }
                case 5: {
                    return "The comment is acceptable, but resolution of the comment and application of any associated changes have been deferred";
                }
                case 6: {
                    return "The comment is a duplicate of another comment already received";
                }
                case 7: {
                    return "The comment is resolved and any necessary changes have been applied";
                }
                case 8: {
                    return "The necessary changes to the artifact have been published in a new version of the artifact";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this.ordinal()) {
                case 0: {
                    return "Submitted";
                }
                case 1: {
                    return "Triaged";
                }
                case 2: {
                    return "Waiting for Input";
                }
                case 3: {
                    return "Resolved - No Change";
                }
                case 4: {
                    return "Resolved - Change Required";
                }
                case 5: {
                    return "Deferred";
                }
                case 6: {
                    return "Duplicate";
                }
                case 7: {
                    return "Applied";
                }
                case 8: {
                    return "Published";
                }
            }
            return "?";
        }
    }

    public static final class ArtifactAssessmentContentType
    extends Enum<ArtifactAssessmentContentType> {
        private static final /* synthetic */ ArtifactAssessmentContentType[] $VALUES;

        public static ArtifactAssessmentContentType[] values() {
            return (ArtifactAssessmentContentType[])$VALUES.clone();
        }

        public static ArtifactAssessmentContentType valueOf(String name) {
            return Enum.valueOf(ArtifactAssessmentContentType.class, name);
        }

        private static /* synthetic */ ArtifactAssessmentContentType[] $values() {
            return new ArtifactAssessmentContentType[0];
        }

        static {
            $VALUES = ArtifactAssessmentContentType.$values();
        }
    }

    public static class ArtifactAssessmentContentClassifierEnumFactory
    implements EnumFactory<ArtifactAssessmentContentClassifier> {
        public ArtifactAssessmentContentClassifier fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("high".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.HIGH;
            }
            if ("moderate".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.MODERATE;
            }
            if ("low".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.LOW;
            }
            if ("very-low".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.VERY_LOW;
            }
            if ("no-concern".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.NO_CONCERN;
            }
            if ("serious-concern".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.SERIOUS_CONCERN;
            }
            if ("very-serious-concern".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.VERY_SERIOUS_CONCERN;
            }
            if ("extremely-serious-concern".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.EXTREMELY_SERIOUS_CONCERN;
            }
            if ("present".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.PRESENT;
            }
            if ("absent".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.ABSENT;
            }
            if ("no-change".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.NO_CHANGE;
            }
            if ("downcode1".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.DOWNCODE1;
            }
            if ("downcode2".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.DOWNCODE2;
            }
            if ("downcode3".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.DOWNCODE3;
            }
            if ("upcode1".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.UPCODE1;
            }
            if ("upcode2".equals(codeString)) {
                return ArtifactAssessmentContentClassifier.UPCODE2;
            }
            throw new IllegalArgumentException("Unknown ArtifactCommentType code '" + codeString + "'");
        }

        public Enumeration<ArtifactAssessmentContentClassifier> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration((EnumFactory)this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("high".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.HIGH);
            }
            if ("moderate".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.MODERATE);
            }
            if ("low".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.LOW);
            }
            if ("very-low".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.VERY_LOW);
            }
            if ("no-concern".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.NO_CONCERN);
            }
            if ("serious-concern".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.SERIOUS_CONCERN);
            }
            if ("very-serious-concern".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.VERY_SERIOUS_CONCERN);
            }
            if ("extremely-serious-concern".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.EXTREMELY_SERIOUS_CONCERN);
            }
            if ("present".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.PRESENT);
            }
            if ("absent".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.ABSENT);
            }
            if ("no-change".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.NO_CHANGE);
            }
            if ("downcode1".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.DOWNCODE1);
            }
            if ("downcode2".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.DOWNCODE2);
            }
            if ("downcode3".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.DOWNCODE3);
            }
            if ("upcode1".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.UPCODE1);
            }
            if ("upcode2".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentClassifier.UPCODE2);
            }
            throw new FHIRException("Unknown ArtifactCommentType code '" + codeString + "'");
        }

        public String toCode(ArtifactAssessmentContentClassifier code) {
            if (code == ArtifactAssessmentContentClassifier.HIGH) {
                return "high";
            }
            if (code == ArtifactAssessmentContentClassifier.MODERATE) {
                return "moderate";
            }
            if (code == ArtifactAssessmentContentClassifier.LOW) {
                return "low";
            }
            if (code == ArtifactAssessmentContentClassifier.VERY_LOW) {
                return "very-low";
            }
            if (code == ArtifactAssessmentContentClassifier.NO_CONCERN) {
                return "no-concern";
            }
            if (code == ArtifactAssessmentContentClassifier.SERIOUS_CONCERN) {
                return "serious-concern";
            }
            if (code == ArtifactAssessmentContentClassifier.VERY_SERIOUS_CONCERN) {
                return "very-serious-concern";
            }
            if (code == ArtifactAssessmentContentClassifier.EXTREMELY_SERIOUS_CONCERN) {
                return "extremely-serious-concern";
            }
            if (code == ArtifactAssessmentContentClassifier.PRESENT) {
                return "present";
            }
            if (code == ArtifactAssessmentContentClassifier.ABSENT) {
                return "absent";
            }
            if (code == ArtifactAssessmentContentClassifier.NO_CHANGE) {
                return "no-change";
            }
            if (code == ArtifactAssessmentContentClassifier.DOWNCODE1) {
                return "downcode1";
            }
            if (code == ArtifactAssessmentContentClassifier.DOWNCODE2) {
                return "downcode2";
            }
            if (code == ArtifactAssessmentContentClassifier.DOWNCODE3) {
                return "downcode3";
            }
            if (code == ArtifactAssessmentContentClassifier.UPCODE1) {
                return "upcode1";
            }
            if (code == ArtifactAssessmentContentClassifier.UPCODE2) {
                return "upcode2";
            }
            return "?";
        }

        public String toSystem(ArtifactAssessmentContentClassifier code) {
            return code.getSystem();
        }
    }

    public static enum ArtifactAssessmentContentClassifier {
        HIGH,
        MODERATE,
        LOW,
        VERY_LOW,
        NO_CONCERN,
        SERIOUS_CONCERN,
        VERY_SERIOUS_CONCERN,
        EXTREMELY_SERIOUS_CONCERN,
        PRESENT,
        ABSENT,
        NO_CHANGE,
        DOWNCODE1,
        DOWNCODE2,
        DOWNCODE3,
        UPCODE1,
        UPCODE2,
        NULL;


        public static ArtifactAssessmentContentClassifier fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("high".equals(codeString)) {
                return HIGH;
            }
            if ("moderate".equals(codeString)) {
                return MODERATE;
            }
            if ("low".equals(codeString)) {
                return LOW;
            }
            if ("very-low".equals(codeString)) {
                return VERY_LOW;
            }
            if ("no-concern".equals(codeString)) {
                return NO_CONCERN;
            }
            if ("serious-concern".equals(codeString)) {
                return SERIOUS_CONCERN;
            }
            if ("very-serious-concern".equals(codeString)) {
                return VERY_SERIOUS_CONCERN;
            }
            if ("extremely-serious-concern".equals(codeString)) {
                return EXTREMELY_SERIOUS_CONCERN;
            }
            if ("present".equals(codeString)) {
                return PRESENT;
            }
            if ("absent".equals(codeString)) {
                return ABSENT;
            }
            if ("no-change".equals(codeString)) {
                return NO_CHANGE;
            }
            if ("downcode1".equals(codeString)) {
                return DOWNCODE1;
            }
            if ("downcode2".equals(codeString)) {
                return DOWNCODE2;
            }
            if ("downcode3".equals(codeString)) {
                return DOWNCODE3;
            }
            if ("upcode1".equals(codeString)) {
                return UPCODE1;
            }
            if ("upcode2".equals(codeString)) {
                return UPCODE2;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ArtifactAssessment '" + codeString + "'");
        }

        public String toCode() {
            switch (this.ordinal()) {
                case 0: {
                    return "high";
                }
                case 1: {
                    return "moderate";
                }
                case 2: {
                    return "low";
                }
                case 3: {
                    return "very-low";
                }
                case 4: {
                    return "no-concern";
                }
                case 5: {
                    return "serious-concern";
                }
                case 6: {
                    return "very-serious-concern";
                }
                case 7: {
                    return "extremely-serious-concern";
                }
                case 8: {
                    return "present";
                }
                case 9: {
                    return "absent";
                }
                case 10: {
                    return "no-change";
                }
                case 11: {
                    return "downcode1";
                }
                case 12: {
                    return "downcode2";
                }
                case 13: {
                    return "downcode3";
                }
                case 14: {
                    return "upcode1";
                }
                case 15: {
                    return "upcode2";
                }
                case 16: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this.ordinal()) {
                case 0: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 1: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 2: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 3: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 4: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 5: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 6: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 7: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 8: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 9: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 10: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 11: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 12: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 13: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 14: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 15: {
                    return "http://terminology.hl7.org/CodeSystem/certainty-rating";
                }
                case 16: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this.ordinal()) {
                case 0: {
                    return "High quality evidence.";
                }
                case 1: {
                    return "Moderate quality evidence.";
                }
                case 2: {
                    return "Low quality evidence.";
                }
                case 3: {
                    return "Very low quality evidence.";
                }
                case 4: {
                    return "No serious concern.";
                }
                case 5: {
                    return "Serious concern.";
                }
                case 6: {
                    return "Very serious concern.";
                }
                case 7: {
                    return "Extremely serious concern.";
                }
                case 8: {
                    return "Possible reason for increasing quality rating was checked and found to be present.";
                }
                case 9: {
                    return "Possible reason for increasing quality rating was checked and found to be absent.";
                }
                case 10: {
                    return "No change to quality rating.";
                }
                case 11: {
                    return "Reduce quality rating by 1.";
                }
                case 12: {
                    return "Reduce quality rating by 2.";
                }
                case 13: {
                    return "Reduce quality rating by 3.";
                }
                case 14: {
                    return "Increase quality rating by 1.";
                }
                case 15: {
                    return "Increase quality rating by 2.";
                }
                case 16: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this.ordinal()) {
                case 0: {
                    return "High quality";
                }
                case 1: {
                    return "Moderate quality";
                }
                case 2: {
                    return "Low quality";
                }
                case 3: {
                    return "Very low quality";
                }
                case 4: {
                    return "No serious concern";
                }
                case 5: {
                    return "Serious concern";
                }
                case 6: {
                    return "Very serious concern";
                }
                case 7: {
                    return "Extremely serious concern";
                }
                case 8: {
                    return "Present";
                }
                case 9: {
                    return "Absent";
                }
                case 10: {
                    return "No change to rating";
                }
                case 11: {
                    return "Reduce rating: -1";
                }
                case 12: {
                    return "Reduce rating: -2";
                }
                case 13: {
                    return "Reduce rating: -3";
                }
                case 14: {
                    return "Increase rating: +1";
                }
                case 15: {
                    return "Increase rating: +2";
                }
                case 16: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ArtifactAssessmentContentInformationTypeEnumFactory
    implements EnumFactory<ArtifactAssessmentContentInformationType> {
        public ArtifactAssessmentContentInformationType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("comment".equals(codeString)) {
                return ArtifactAssessmentContentInformationType.COMMENT;
            }
            if ("classifier".equals(codeString)) {
                return ArtifactAssessmentContentInformationType.CLASSIFIER;
            }
            if ("rating".equals(codeString)) {
                return ArtifactAssessmentContentInformationType.RATING;
            }
            if ("container".equals(codeString)) {
                return ArtifactAssessmentContentInformationType.CONTAINER;
            }
            if ("response".equals(codeString)) {
                return ArtifactAssessmentContentInformationType.RESPONSE;
            }
            if ("change-request".equals(codeString)) {
                return ArtifactAssessmentContentInformationType.CHANGEREQUEST;
            }
            throw new IllegalArgumentException("Unknown ArtifactCommentType code '" + codeString + "'");
        }

        public Enumeration<ArtifactAssessmentContentInformationType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration((EnumFactory)this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("comment".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentInformationType.COMMENT);
            }
            if ("classifier".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentInformationType.CLASSIFIER);
            }
            if ("rating".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentInformationType.RATING);
            }
            if ("container".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentInformationType.CONTAINER);
            }
            if ("response".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentInformationType.RESPONSE);
            }
            if ("change-request".equals(codeString)) {
                return new Enumeration((EnumFactory)this, (Enum)ArtifactAssessmentContentInformationType.CHANGEREQUEST);
            }
            throw new FHIRException("Unknown ArtifactCommentType code '" + codeString + "'");
        }

        public String toCode(ArtifactAssessmentContentInformationType code) {
            if (code == ArtifactAssessmentContentInformationType.COMMENT) {
                return "comment";
            }
            if (code == ArtifactAssessmentContentInformationType.CLASSIFIER) {
                return "classifier";
            }
            if (code == ArtifactAssessmentContentInformationType.RATING) {
                return "rating";
            }
            if (code == ArtifactAssessmentContentInformationType.CONTAINER) {
                return "container";
            }
            if (code == ArtifactAssessmentContentInformationType.RESPONSE) {
                return "response";
            }
            if (code == ArtifactAssessmentContentInformationType.CHANGEREQUEST) {
                return "change-request";
            }
            return "?";
        }

        public String toSystem(ArtifactAssessmentContentInformationType code) {
            return code.getSystem();
        }
    }

    public static enum ArtifactAssessmentContentInformationType {
        COMMENT,
        CLASSIFIER,
        RATING,
        CONTAINER,
        RESPONSE,
        CHANGEREQUEST,
        NULL;


        public static ArtifactAssessmentContentInformationType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("comment".equals(codeString)) {
                return COMMENT;
            }
            if ("classifier".equals(codeString)) {
                return CLASSIFIER;
            }
            if ("rating".equals(codeString)) {
                return RATING;
            }
            if ("container".equals(codeString)) {
                return CONTAINER;
            }
            if ("response".equals(codeString)) {
                return RESPONSE;
            }
            if ("change-request".equals(codeString)) {
                return CHANGEREQUEST;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ArtifactAssessment '" + codeString + "'");
        }

        public String toCode() {
            switch (this.ordinal()) {
                case 0: {
                    return "comment";
                }
                case 1: {
                    return "classifier";
                }
                case 2: {
                    return "rating";
                }
                case 3: {
                    return "container";
                }
                case 4: {
                    return "response";
                }
                case 5: {
                    return "change-request";
                }
                case 6: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this.ordinal()) {
                case 0: {
                    return "http://hl7.org/fhir/ValueSet/artifactassessment-information-type";
                }
                case 1: {
                    return "http://hl7.org/fhir/ValueSet/artifactassessment-information-type";
                }
                case 2: {
                    return "http://hl7.org/fhir/ValueSet/artifactassessment-information-type";
                }
                case 3: {
                    return "http://hl7.org/fhir/ValueSet/artifactassessment-information-type";
                }
                case 4: {
                    return "http://hl7.org/fhir/ValueSet/artifactassessment-information-type";
                }
                case 5: {
                    return "http://hl7.org/fhir/ValueSet/artifactassessment-information-type";
                }
                case 6: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this.ordinal()) {
                case 0: {
                    return "A comment on the artifact.";
                }
                case 1: {
                    return "A classifier of the artifact.";
                }
                case 2: {
                    return "A rating  of the artifact.";
                }
                case 3: {
                    return "A container for multiple components.";
                }
                case 4: {
                    return "A response to a comment.";
                }
                case 5: {
                    return "A change request for the artifact.";
                }
                case 6: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this.ordinal()) {
                case 0: {
                    return "Comment";
                }
                case 1: {
                    return "Classifier";
                }
                case 2: {
                    return "Rating";
                }
                case 3: {
                    return "Container";
                }
                case 4: {
                    return "Response";
                }
                case 5: {
                    return "Change Request";
                }
                case 6: {
                    return null;
                }
            }
            return "?";
        }
    }
}

