/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.visitor.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.ValueSet;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.Constants;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.client.TerminologyServerClient;

public class KnowledgeArtifactPackageVisitor {
    private TerminologyServerClient terminologyServerClient = new TerminologyServerClient(FhirContext.forR4());
    public static final List<ResourceType> canonicalResourceTypes = Collections.unmodifiableList(new ArrayList<ResourceType>(Arrays.asList(ResourceType.ActivityDefinition, ResourceType.CapabilityStatement, ResourceType.ChargeItemDefinition, ResourceType.CompartmentDefinition, ResourceType.ConceptMap, ResourceType.EffectEvidenceSynthesis, ResourceType.EventDefinition, ResourceType.Evidence, ResourceType.EvidenceVariable, ResourceType.ExampleScenario, ResourceType.GraphDefinition, ResourceType.ImplementationGuide, ResourceType.Library, ResourceType.Measure, ResourceType.MessageDefinition, ResourceType.NamingSystem, ResourceType.OperationDefinition, ResourceType.PlanDefinition, ResourceType.Questionnaire, ResourceType.ResearchDefinition, ResourceType.ResearchElementDefinition, ResourceType.RiskEvidenceSynthesis, ResourceType.SearchParameter, ResourceType.StructureDefinition, ResourceType.StructureMap, ResourceType.TerminologyCapabilities, ResourceType.TestScript, ResourceType.ValueSet)));
    public static final List<ResourceType> conformanceResourceTypes = Collections.unmodifiableList(new ArrayList<ResourceType>(Arrays.asList(ResourceType.CapabilityStatement, ResourceType.StructureDefinition, ResourceType.ImplementationGuide, ResourceType.SearchParameter, ResourceType.MessageDefinition, ResourceType.OperationDefinition, ResourceType.CompartmentDefinition, ResourceType.StructureMap, ResourceType.GraphDefinition, ResourceType.ExampleScenario)));
    public static final List<ResourceType> knowledgeArtifactResourceTypes = Collections.unmodifiableList(new ArrayList<ResourceType>(Arrays.asList(ResourceType.Library, ResourceType.Measure, ResourceType.ActivityDefinition, ResourceType.PlanDefinition)));
    public static final List<ResourceType> terminologyResourceTypes = Collections.unmodifiableList(new ArrayList<ResourceType>(Arrays.asList(ResourceType.CodeSystem, ResourceType.ValueSet, ResourceType.ConceptMap, ResourceType.NamingSystem, ResourceType.TerminologyCapabilities)));

    public static void setCorrectBundleType(Optional<Integer> count, Optional<Integer> offset, Bundle bundle) {
        if (count.isPresent() && count.get() == 0) {
            bundle.setType(Bundle.BundleType.SEARCHSET);
            bundle.setTotal(bundle.getEntry().size());
        } else if (offset.isPresent() && offset.get() > 0 || count.isPresent() && count.get() < bundle.getEntry().size()) {
            bundle.setType(Bundle.BundleType.COLLECTION);
            List removedRequest = bundle.getEntry().stream().map(entry -> {
                entry.setRequest(null);
                return entry;
            }).collect(Collectors.toList());
            bundle.setEntry(removedRequest);
        } else {
            bundle.setType(Bundle.BundleType.TRANSACTION);
        }
    }

    public static List<Bundle.BundleEntryComponent> findUnsupportedInclude(List<Bundle.BundleEntryComponent> entries, List<String> include) {
        if (include == null || include.isEmpty() || include.stream().anyMatch(includedType -> includedType.equals("all"))) {
            return entries;
        }
        ArrayList filteredList = new ArrayList();
        entries.stream().forEach(entry -> {
            Boolean resourceIsConformanceType;
            Boolean resourceIsTerminologyType;
            Boolean resourceIsCanonicalType;
            Boolean resourceIsKnowledgeType;
            if (include.stream().anyMatch(type -> type.equals("knowledge")) && (resourceIsKnowledgeType = Boolean.valueOf(knowledgeArtifactResourceTypes.contains(entry.getResource().getResourceType()))).booleanValue()) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("canonical")) && (resourceIsCanonicalType = Boolean.valueOf(canonicalResourceTypes.contains(entry.getResource().getResourceType()))).booleanValue()) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("terminology")) && (resourceIsTerminologyType = Boolean.valueOf(terminologyResourceTypes.contains(entry.getResource().getResourceType()))).booleanValue()) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("conformance")) && (resourceIsConformanceType = Boolean.valueOf(conformanceResourceTypes.contains(entry.getResource().getResourceType()))).booleanValue()) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("extensions")) && entry.getResource().getResourceType().equals((Object)ResourceType.StructureDefinition) && ((StructureDefinition)entry.getResource()).getType().equals("Extension")) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("profiles")) && entry.getResource().getResourceType().equals((Object)ResourceType.StructureDefinition) && !((StructureDefinition)entry.getResource()).getType().equals("Extension")) {
                filteredList.add(entry);
            }
            if (include.stream().anyMatch(type -> type.equals("tests"))) {
                if (entry.getResource().getResourceType().equals((Object)ResourceType.Library) && ((Library)entry.getResource()).getType().getCoding().stream().anyMatch(coding -> coding.getCode().equals("test-case"))) {
                    filteredList.add(entry);
                } else if (((MetadataResource)entry.getResource()).getExtension().stream().anyMatch(ext -> ext.getUrl().contains("isTestCase") && (Boolean)((BooleanType)ext.getValue()).getValue() != false)) {
                    filteredList.add(entry);
                }
            }
            if (include.stream().anyMatch(type -> type.equals("examples")) && ((MetadataResource)entry.getResource()).getExtension().stream().anyMatch(ext -> ext.getUrl().contains("isExample") && (Boolean)((BooleanType)ext.getValue()).getValue() != false)) {
                filteredList.add(entry);
            }
        });
        ArrayList<Bundle.BundleEntryComponent> distinctFilteredEntries = new ArrayList<Bundle.BundleEntryComponent>();
        for (Bundle.BundleEntryComponent entry2 : filteredList) {
            if (distinctFilteredEntries.stream().map(e -> (MetadataResource)e.getResource()).anyMatch(existingEntry -> existingEntry.getUrl().equals(((MetadataResource)entry2.getResource()).getUrl()) && existingEntry.getVersion().equals(((MetadataResource)entry2.getResource()).getVersion()))) continue;
            distinctFilteredEntries.add(entry2);
        }
        return distinctFilteredEntries;
    }

    public void handleValueSetReferenceExtensions(MetadataResource manifest, List<Bundle.BundleEntryComponent> bundleEntries, Repository repository, Optional<Endpoint> terminologyEndpoint) throws UnprocessableEntityException, IllegalArgumentException {
        Extension expansionParamsExtension;
        KnowledgeArtifactAdapter adapter = AdapterFactory.forFhirVersion(manifest.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter((IDomainResource)manifest);
        List<RelatedArtifact> relatedArtifactsWithPreservedExtension = this.getRelatedArtifactsWithPreservedExtensions(adapter.getRelatedArtifact());
        Parameters expansionParams = new Parameters();
        Library rootSpecificationLibrary = KnowledgeArtifactPackageVisitor.getRootSpecificationLibrary(bundleEntries);
        if (rootSpecificationLibrary != null && (expansionParamsExtension = rootSpecificationLibrary.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-expansionParameters")) != null && expansionParamsExtension.hasValue()) {
            Reference expansionReference = (Reference)expansionParamsExtension.getValue();
            expansionParams = KnowledgeArtifactPackageVisitor.getExpansionParams(rootSpecificationLibrary, expansionReference.getReference());
        }
        Parameters params = expansionParams;
        bundleEntries.stream().forEach(entry -> {
            if (entry.getResource().getResourceType().equals((Object)ResourceType.ValueSet)) {
                ValueSet valueSet = (ValueSet)entry.getResource();
                List<UsageContext> usageContexts = this.removeExistingReferenceExtensionData(valueSet.getUseContext());
                valueSet.setUseContext(usageContexts);
                Optional<RelatedArtifact> maybeVSRelatedArtifact = relatedArtifactsWithPreservedExtension.stream().filter(ra -> Canonicals.getUrl(ra.getResource()).equals(valueSet.getUrl())).findFirst();
                this.checkIfValueSetNeedsCondition((IBaseResource)valueSet, maybeVSRelatedArtifact.orElse(null));
                if (!valueSet.hasCompose() || valueSet.hasCompose() && valueSet.getCompose().getIncludeFirstRep().getValueSet().isEmpty()) {
                    this.expandValueSet(valueSet, params, terminologyEndpoint);
                    maybeVSRelatedArtifact.map(ra -> ra.getExtension()).ifPresent(exts -> exts.stream().filter(ext -> ext.getUrl().equalsIgnoreCase("http://aphl.org/fhir/vsm/StructureDefinition/vsm-valueset-condition")).forEach(ext -> this.tryAddCondition(usageContexts, (CodeableConcept)ext.getValue())));
                }
                UsageContext priority = this.getOrCreateUsageContext(usageContexts, "http://hl7.org/fhir/us/ecr/CodeSystem/us-ph-usage-context-type", "priority");
                Optional<Extension> ext = maybeVSRelatedArtifact.map(ra -> ra.getExtensionByUrl("http://aphl.org/fhir/vsm/StructureDefinition/vsm-valueset-priority"));
                if (ext.isPresent()) {
                    priority.setValue(ext.get().getValue());
                } else {
                    CodeableConcept routine = new CodeableConcept(new Coding("http://hl7.org/fhir/us/ecr/CodeSystem/us-ph-usage-context", "routine", null)).setText("Routine");
                    priority.setValue((Type)routine);
                }
            }
        });
    }

    public void expandValueSet(ValueSet valueSet, Parameters expansionParameters, Optional<Endpoint> terminologyEndpoint) {
        String authoritativeSourceUrl;
        Extension authoritativeSource = valueSet.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/valueset-authoritativeSource");
        String string = authoritativeSourceUrl = authoritativeSource != null && authoritativeSource.hasValue() ? authoritativeSource.getValue().primitiveValue() : valueSet.getUrl();
        if (this.isVSMAuthoredValueSet(valueSet) && this.hasSimpleCompose(valueSet)) {
            ValueSet.ValueSetExpansionComponent expansion = new ValueSet.ValueSetExpansionComponent();
            expansion.setTimestamp(Date.from(Instant.now()));
            ArrayList<ValueSet.ValueSetExpansionParameterComponent> expansionParams = new ArrayList<ValueSet.ValueSetExpansionParameterComponent>();
            ValueSet.ValueSetExpansionParameterComponent parameterNaive = new ValueSet.ValueSetExpansionParameterComponent();
            parameterNaive.setName("naive");
            parameterNaive.setValue((Type)new BooleanType(true));
            expansionParams.add(parameterNaive);
            expansion.setParameter(expansionParams);
            for (ValueSet.ConceptSetComponent csc : valueSet.getCompose().getInclude()) {
                for (ValueSet.ConceptReferenceComponent crc : csc.getConcept()) {
                    expansion.addContains().setCode(crc.getCode()).setSystem(csc.getSystem()).setVersion(csc.getVersion()).setDisplay(crc.getDisplay());
                }
            }
            valueSet.setExpansion(expansion);
        } else {
            if (!terminologyEndpoint.isPresent()) {
                throw new UnprocessableEntityException("Cannot expand ValueSet without credentials: " + valueSet.getId());
            }
            String username = terminologyEndpoint.get().getExtensionsByUrl("vsacUsername").stream().findFirst().map(ext -> ext.getValue().toString()).orElseThrow(() -> new UnprocessableEntityException("Cannot expand ValueSet without VSAC Username: " + valueSet.getId()));
            String apiKey = terminologyEndpoint.get().getExtensionsByUrl("apiKey").stream().findFirst().map(ext -> ext.getValue().toString()).orElseThrow(() -> new UnprocessableEntityException("Cannot expand ValueSet without VSAC API Key: " + valueSet.getId()));
            try {
                ValueSet expandedValueSet = this.terminologyServerClient.expand(valueSet, authoritativeSourceUrl, expansionParameters, username, apiKey);
                valueSet.setExpansion(expandedValueSet.getExpansion());
            }
            catch (Exception ex) {
                throw new UnprocessableEntityException(new String[]{"Terminology Server expansion failed for: " + valueSet.getId(), ex.getMessage()});
            }
        }
    }

    protected boolean isVSMAuthoredValueSet(ValueSet valueSet) {
        return valueSet.hasMeta() && valueSet.getMeta().hasTag() && valueSet.getMeta().getTag("http://aphl.org/fhir/vsm/CodeSystem/vsm-workflow-codes", "vsm-authored") != null;
    }

    protected boolean hasSimpleCompose(ValueSet valueSet) {
        return valueSet.hasCompose() && !valueSet.getCompose().hasExclude() && valueSet.getCompose().getInclude().stream().noneMatch(csc -> csc.hasValueSet() || csc.hasFilter() || !csc.hasSystem() || !csc.hasConcept());
    }

    protected List<RelatedArtifact> getRelatedArtifactsWithPreservedExtensions(List<RelatedArtifact> deps) {
        return deps.stream().filter(ra -> Constants.PRESERVED_EXTENSION_URLS.stream().anyMatch(url -> ra.getExtension().stream().anyMatch(ext -> ext.getUrl().equalsIgnoreCase((String)url)))).collect(Collectors.toList());
    }

    protected static Library getRootSpecificationLibrary(List<Bundle.BundleEntryComponent> bundleEntries) {
        Optional<Library> rootSpecLibrary = bundleEntries.stream().filter(entry -> entry.getResource().getResourceType() == ResourceType.Library).map(entry -> (Library)entry.getResource()).filter(entry -> entry.getType().hasCoding("http://terminology.hl7.org/CodeSystem/library-type", "asset-collection") && entry.getUseContext().stream().allMatch(useContext -> useContext.getCode().getSystem().equals("http://hl7.org/fhir/us/ecr/CodeSystem/us-ph-usage-context-type") && useContext.getCode().getCode().equals("reporting") && useContext.getValueCodeableConcept().hasCoding("http://hl7.org/fhir/us/ecr/CodeSystem/us-ph-usage-context", "triggering") || useContext.getCode().getSystem().equals("http://hl7.org/fhir/us/ecr/CodeSystem/us-ph-usage-context-type") && useContext.getCode().getCode().equals("specification-type") && useContext.getValueCodeableConcept().hasCoding("http://hl7.org/fhir/us/ecr/CodeSystem/us-ph-usage-context", "program"))).findFirst();
        return rootSpecLibrary.orElse(null);
    }

    protected static Parameters getExpansionParams(Library rootSpecificationLibrary, String reference) {
        Optional<Resource> expansionParamResource = rootSpecificationLibrary.getContained().stream().filter(contained -> contained.getId().equals(reference)).findFirst();
        return expansionParamResource.orElse(null);
    }

    protected void checkIfValueSetNeedsCondition(IBaseResource resource, RelatedArtifact relatedArtifact) throws UnprocessableEntityException {
        if (resource != null && resource.fhirType().equals(ResourceType.ValueSet.name())) {
            ValueSet valueSet = (ValueSet)resource;
            boolean isLeaf = !valueSet.hasCompose() || valueSet.hasCompose() && valueSet.getCompose().getIncludeFirstRep().getValueSet().isEmpty();
            Optional<Extension> maybeConditionExtension = Optional.ofNullable(relatedArtifact).map(Element::getExtension).map(list -> list.stream().filter(ext -> ext.getUrl().equalsIgnoreCase("http://aphl.org/fhir/vsm/StructureDefinition/vsm-valueset-condition")).findFirst().orElse(null));
            Optional<Extension> maybePriorityExtension = Optional.ofNullable(relatedArtifact).map(Element::getExtension).map(list -> list.stream().filter(ext -> ext.getUrl().equalsIgnoreCase("http://aphl.org/fhir/vsm/StructureDefinition/vsm-valueset-priority")).findFirst().orElse(null));
            if (!(!isLeaf || maybeConditionExtension.isPresent() && maybePriorityExtension.isPresent())) {
                if (!maybeConditionExtension.isPresent() && !maybePriorityExtension.isPresent()) {
                    throw new UnprocessableEntityException("Missing condition and priority references on ValueSet : " + valueSet.getUrl());
                }
                if (!maybeConditionExtension.isPresent()) {
                    throw new UnprocessableEntityException("Missing condition reference on ValueSet : " + valueSet.getUrl());
                }
                throw new UnprocessableEntityException("Missing priority reference on ValueSet : " + valueSet.getUrl());
            }
        }
    }

    protected List<UsageContext> removeExistingReferenceExtensionData(List<UsageContext> usageContexts) {
        List<String> useContextCodesToReplace = Collections.unmodifiableList(Arrays.asList("focus", "priority"));
        return usageContexts.stream().filter(useContext -> !useContextCodesToReplace.stream().anyMatch(code -> useContext.getCode().getCode().equals(code))).collect(Collectors.toList());
    }

    protected void tryAddCondition(List<UsageContext> usageContexts, CodeableConcept condition) {
        boolean focusAlreadyExists = usageContexts.stream().anyMatch(u -> u.getCode().getSystem().equals("http://terminology.hl7.org/CodeSystem/usage-context-type") && u.getCode().getCode().equals("focus") && u.getValueCodeableConcept().hasCoding(((Coding)condition.getCoding().get(0)).getSystem(), ((Coding)condition.getCoding().get(0)).getCode()));
        if (!focusAlreadyExists) {
            UsageContext newFocus = new UsageContext(new Coding("http://hl7.org/fhir/us/ecr/CodeSystem/us-ph-usage-context", "focus", null), (Type)condition);
            newFocus.setValue((Type)condition);
            usageContexts.add(newFocus);
        }
    }

    protected UsageContext getOrCreateUsageContext(List<UsageContext> usageContexts, String system, String code) {
        return usageContexts.stream().filter(useContext -> useContext.getCode().getSystem().equals(system) && useContext.getCode().getCode().equals(code)).findFirst().orElseGet(() -> {
            Coding c = new Coding(system, code, null);
            UsageContext n = new UsageContext(c, null);
            usageContexts.add(n);
            return n;
        });
    }
}

