/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.visitor.r5;

import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.ValueSet;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.r5.CRMIReleaseExperimentalBehavior;
import org.opencds.cqf.fhir.utility.r5.CRMIReleaseVersionBehavior;
import org.slf4j.Logger;

public class KnowledgeArtifactReleaseVisitor {
    public static void checkNonExperimental(MetadataResource resource, CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes experimentalBehavior, Repository repository, Logger log) throws UnprocessableEntityException {
        if (CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NULL != experimentalBehavior && CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.NONE != experimentalBehavior) {
            String nonExperimentalError = String.format("Root artifact is not Experimental, but references an Experimental resource with URL '%s'.", resource.getUrl());
            if (CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.WARN == experimentalBehavior && resource.getExperimental()) {
                log.warn(nonExperimentalError);
            } else if (CRMIReleaseExperimentalBehavior.CRMIReleaseExperimentalBehaviorCodes.ERROR == experimentalBehavior && resource.getExperimental()) {
                throw new UnprocessableEntityException(nonExperimentalError);
            }
            if (resource.getResourceType().equals((Object)ResourceType.ValueSet)) {
                ValueSet valueSet = (ValueSet)resource;
                List valueSets = valueSet.getCompose().getInclude().stream().flatMap(include -> include.getValueSet().stream()).collect(Collectors.toList());
                for (IPrimitiveType value : valueSets) {
                    KnowledgeArtifactAdapter.findLatestVersion(SearchHelper.searchRepositoryByCanonicalWithPaging(repository, value)).ifPresent(childVs -> KnowledgeArtifactReleaseVisitor.checkNonExperimental((MetadataResource)childVs, experimentalBehavior, repository, log));
                }
            }
        }
    }

    public static void propagageEffectivePeriod(Period rootEffectivePeriod, KnowledgeArtifactAdapter artifactAdapter) {
        Period effectivePeriod = (Period)artifactAdapter.getEffectivePeriod();
        if (rootEffectivePeriod != null && (rootEffectivePeriod.hasStart() || rootEffectivePeriod.hasEnd()) && (effectivePeriod == null || !effectivePeriod.hasStart() && !effectivePeriod.hasEnd())) {
            artifactAdapter.setEffectivePeriod((ICompositeType)rootEffectivePeriod);
        }
    }

    public static void updateReleaseLabel(MetadataResource artifact, String releaseLabel) throws IllegalArgumentException {
        if (releaseLabel != null) {
            Extension releaseLabelExtension = artifact.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/artifact-releaseLabel");
            if (releaseLabelExtension == null) {
                releaseLabelExtension = new Extension("http://hl7.org/fhir/StructureDefinition/artifact-releaseLabel");
                artifact.addExtension(releaseLabelExtension);
            }
            releaseLabelExtension.setValue((DataType)new StringType(releaseLabel));
        }
    }

    public static Bundle searchArtifactAssessmentForArtifact(IIdType reference, Repository repository) {
        HashMap searchParams = new HashMap();
        ArrayList<ReferenceParam> urlList = new ArrayList<ReferenceParam>();
        urlList.add(new ReferenceParam(reference));
        searchParams.put("artifact", urlList);
        Bundle searchResultsBundle = (Bundle)repository.search(Bundle.class, ArtifactAssessment.class, searchParams);
        return searchResultsBundle;
    }

    public static Optional<String> getReleaseVersion(String version, Optional<String> versionBehavior, String existingVersion) {
        Optional<String> releaseVersion = Optional.empty();
        if (versionBehavior.isPresent()) {
            CRMIReleaseVersionBehavior.CRMIReleaseVersionBehaviorCodes versionBehaviorCode = CRMIReleaseVersionBehavior.CRMIReleaseVersionBehaviorCodes.fromCode(versionBehavior.get());
            if (existingVersion == null || existingVersion.isEmpty() || StringUtils.isBlank((CharSequence)existingVersion)) {
                return Optional.ofNullable(version);
            }
            String replaceDraftInExisting = existingVersion.replace("-draft", "");
            if (CRMIReleaseVersionBehavior.CRMIReleaseVersionBehaviorCodes.DEFAULT == versionBehaviorCode) {
                releaseVersion = replaceDraftInExisting != null && !replaceDraftInExisting.isEmpty() ? Optional.of(replaceDraftInExisting) : Optional.ofNullable(version);
            } else if (CRMIReleaseVersionBehavior.CRMIReleaseVersionBehaviorCodes.FORCE == versionBehaviorCode) {
                releaseVersion = Optional.ofNullable(version);
            } else if (CRMIReleaseVersionBehavior.CRMIReleaseVersionBehaviorCodes.CHECK == versionBehaviorCode && !replaceDraftInExisting.equals(version)) {
                throw new UnprocessableEntityException(String.format("versionBehavior specified is 'check' and the version provided ('%s') does not match the version currently specified on the root artifact ('%s').", version, existingVersion));
            }
        }
        return releaseVersion;
    }

    public static List<Bundle.BundleEntryComponent> findArtifactCommentsToUpdate(MetadataResource rootArtifact, String releaseVersion, Repository repository) {
        ArrayList<Bundle.BundleEntryComponent> returnEntries = new ArrayList<Bundle.BundleEntryComponent>();
        KnowledgeArtifactReleaseVisitor.searchArtifactAssessmentForArtifact((IIdType)rootArtifact.getIdElement(), repository).getEntry().stream().map(entry -> (ArtifactAssessment)entry.getResource()).filter(entry -> entry != null).forEach(artifactComment -> {
            RelatedArtifact ra = artifactComment.getContentFirstRep().addRelatedArtifact();
            ra.setType(RelatedArtifact.RelatedArtifactType.DERIVEDFROM).setResource(String.format("%s|%s", rootArtifact.getUrl(), releaseVersion));
            returnEntries.add((Bundle.BundleEntryComponent)PackageHelper.createEntry((IBaseResource)artifactComment, true));
        });
        return returnEntries;
    }
}

