package com_atlassian_clover;

import com.atlassian.clover.instr.ForInstrumentation;

public class CloverVersionInfo {
    public static final String RELEASE_NUM = "4.5.1";

    public static final String SANITIZED_RN = "4_5_1";

    /** Main web site */
    public static final String ATLASSIAN_COM = "https://openclover.org";

    /** Main Support Resources page */
    public static final String ATLASSIAN_COM_SUPPORT_RESOURCES = "https://openclover.org/support";

    /** Main Clover web site */
    public static final String CLOVER_URL ="https://openclover.org";

    /** Help how to configure Clover license */
    public static final String CLOVER_LICENSE_CONFIGURATION_HELP_URL ="https://openclover.org/documentation";

    /** Servlet for creating new JIRA issue */
    public static final String CLOVER_CREATE_ISSUE_URL = "https://github.com/openclover/clover/issues";

    public static final String BUILD_DATE ="2023-10-29";

    public static final long BUILD_STAMP = 20231029181002L;

    /** @deprecated */
    public static String TITLE_PREFIX = "";


    /** method to allow external components to query what version of Clover they are running against **/
    @ForInstrumentation
    public static String getReleaseNum() {
        return RELEASE_NUM;
    }

    /** method to allow external components to query what version of Clover they are running against **/
    @ForInstrumentation
    public static long getBuildStamp() {
        return BUILD_STAMP;
    }
    
    /** Format version information Release Number, Build Number and Build Date. **/
    public static String formatVersionInfo() {
        return "Version: " + RELEASE_NUM + " Built: " + BUILD_DATE;
    }

    @ForInstrumentation("oldVersionInClasspath")
    public static void An_old_version_of_clover_is_on_your_compilation_classpath___Please_remove___Required_version_is___4_5_1(){}
}
