/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.Logger;
import com.atlassian.clover.recorder.BaseCoverageRecorder;
import com.atlassian.clover.recorder.CoverageSnapshot;
import com.atlassian.clover.recorder.GlobalRecordingWriteStrategy;
import com.atlassian.clover.recorder.NullRecorder;
import com.atlassian.clover.registry.RegistryFormatException;
import com.atlassian.clover.registry.format.RegAccessMode;
import com.atlassian.clover.registry.format.RegHeader;
import com.atlassian.clover.util.CloverBitSet;
import com_atlassian_clover.CoverageRecorder;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;

public final class FixedSizeCoverageRecorder
extends BaseCoverageRecorder {
    private static final Set<String> TRUNC_WARNING_DBS = Collections.synchronizedSet(new HashSet());
    private static final Set<String> MERGE_WARNING_DBS = Collections.synchronizedSet(new HashSet());
    private final int[] elements;

    public static CoverageRecorder createFor(final File dbFile, final long dbVersion, int maxNumElements, final long cfgbits) throws IOException, RegistryFormatException {
        RegHeader header = RegHeader.readFrom(dbFile);
        if (header.getAccessMode() == RegAccessMode.READWRITE) {
            final int numElementsInDb = header.getSlotCount();
            return FixedSizeCoverageRecorder.recorderBigEnoughFor(dbFile.getAbsolutePath(), maxNumElements, numElementsInDb, new NewRecorderBlock(){

                @Override
                public CoverageRecorder call() {
                    return new FixedSizeCoverageRecorder(dbFile.getAbsolutePath(), dbVersion, numElementsInDb, cfgbits);
                }
            });
        }
        if (!MERGE_WARNING_DBS.contains(dbFile.getAbsolutePath())) {
            MERGE_WARNING_DBS.add(dbFile.getAbsolutePath());
            Logger.getInstance().warn("CLOVER: Clover database: '" + dbFile.getAbsolutePath() + "' can only be used for reporting because it is the result of a merge.");
            Logger.getInstance().warn("CLOVER: Coverage data for some classes will not be gathered.");
        }
        return NullRecorder.INSTANCE;
    }

    FixedSizeCoverageRecorder(String dbName, long dbVersion, int numElements, long cfgbits) {
        this(dbName, dbVersion, numElements, cfgbits, GlobalRecordingWriteStrategy.WRITE_TO_FILE);
    }

    FixedSizeCoverageRecorder(String dbName, long dbVersion, int numElements, long cfgbits, GlobalRecordingWriteStrategy writeStrategy) {
        super(dbName, dbVersion, cfgbits, writeStrategy);
        this.elements = new int[numElements];
    }

    @Override
    public CloverBitSet compareCoverageWith(CoverageSnapshot before) {
        int[] beforeElements = before.getCoverage()[0];
        for (int i = 0; i < beforeElements.length; ++i) {
            beforeElements[i] = beforeElements[i] - this.elements[i];
        }
        return CloverBitSet.forHits(beforeElements);
    }

    @Override
    public CloverBitSet createEmptyHitsMask() {
        return new CloverBitSet(this.elements.length);
    }

    @Override
    public void inc(int index) {
        this.testCoverage.set(index);
        int n = index;
        this.elements[n] = this.elements[n] + 1;
    }

    @Override
    public int iget(int index) {
        this.testCoverage.set(index);
        int n = index;
        int n2 = this.elements[n] + 1;
        this.elements[n] = n2;
        return n2;
    }

    @Override
    protected String write() throws IOException {
        return this.write(new int[][]{this.elements}, this.elements.length);
    }

    @Override
    public CoverageRecorder withCapacityFor(int maxNumElements) {
        return FixedSizeCoverageRecorder.recorderBigEnoughFor(this.dbName, maxNumElements, this.elements.length, new NewRecorderBlock(){

            @Override
            public CoverageRecorder call() {
                return FixedSizeCoverageRecorder.this;
            }
        });
    }

    @Override
    public CoverageSnapshot getCoverageSnapshot() {
        return new CoverageSnapshot(new int[][]{(int[])this.elements.clone()});
    }

    private static CoverageRecorder recorderBigEnoughFor(String dbName, int numRequiredElements, int numAvailableElements, NewRecorderBlock recorderIfSufficient) {
        if (numRequiredElements > numAvailableElements) {
            FixedSizeCoverageRecorder.logInsufficientCapacity(dbName, numRequiredElements, numAvailableElements);
            return NullRecorder.INSTANCE;
        }
        return recorderIfSufficient.call();
    }

    private static void logInsufficientCapacity(String dbName, int numRequiredElements, int numAvailableElements) {
        if (!TRUNC_WARNING_DBS.contains(dbName)) {
            TRUNC_WARNING_DBS.add(dbName);
            Logger.getInstance().warn("CLOVER: Clover database: '" + dbName + "' is no longer valid. Min required size for currently loading class: " + numRequiredElements + ", actual size: " + numAvailableElements);
            Logger.getInstance().warn("CLOVER: Coverage data for some classes will not be gathered.");
        }
    }

    public String toString() {
        return "FixedSizeCoverageRecorder[elements.length=" + this.elements.length + "]";
    }

    private static interface NewRecorderBlock
    extends Callable<CoverageRecorder> {
        @Override
        public CoverageRecorder call();
    }
}

