/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.recorder.GlobalRecordingWriteStrategy;
import com.atlassian.clover.recorder.GrowableCoverageRecorder;
import com_atlassian_clover.CoverageRecorder;
import java.util.HashMap;
import java.util.Map;

public final class SharedCoverageRecorder
extends GrowableCoverageRecorder {
    static final Map<String, CoverageRecorder> sharedRecorders = new HashMap<String, CoverageRecorder>();

    public static synchronized CoverageRecorder createFor(String dbName, long dbVersion, long cfgbits, int maxNumElements) {
        String key = dbName + "_" + cfgbits;
        if (sharedRecorders.containsKey(key)) {
            CoverageRecorder recorder = sharedRecorders.get(key).withCapacityFor(maxNumElements);
            sharedRecorders.put(key, recorder);
            return recorder;
        }
        CoverageRecorder recorder = new SharedCoverageRecorder(dbName, dbVersion, cfgbits, maxNumElements).withCapacityFor(maxNumElements);
        sharedRecorders.put(key, recorder);
        return recorder;
    }

    private SharedCoverageRecorder(String dbName, long dbVersion, long cfgbits, int maxNumElements) {
        super(dbName, dbVersion, cfgbits, maxNumElements, GlobalRecordingWriteStrategy.WRITE_TO_FILE);
    }

    @Override
    public String toString() {
        return "SharedCoverageRecorder[growableRecorder=" + super.toString() + "]";
    }
}

