/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.panel;

import clover.org.jfree.chart.event.OverlayChangeEvent;
import clover.org.jfree.chart.event.OverlayChangeListener;
import clover.org.jfree.chart.util.ParamChecks;
import javax.swing.event.EventListenerList;

public class AbstractOverlay {
    private transient EventListenerList changeListeners = new EventListenerList();

    public void addChangeListener(OverlayChangeListener listener) {
        ParamChecks.nullNotPermitted(listener, "listener");
        this.changeListeners.add(OverlayChangeListener.class, listener);
    }

    public void removeChangeListener(OverlayChangeListener listener) {
        ParamChecks.nullNotPermitted(listener, "listener");
        this.changeListeners.remove(OverlayChangeListener.class, listener);
    }

    public void fireOverlayChanged() {
        OverlayChangeEvent event = new OverlayChangeEvent(this);
        this.notifyListeners(event);
    }

    protected void notifyListeners(OverlayChangeEvent event) {
        Object[] listeners = this.changeListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != OverlayChangeListener.class) continue;
            ((OverlayChangeListener)listeners[i + 1]).overlayChanged(event);
        }
    }
}

