/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import com.atlassian.clover.CloverStartup;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.command.ArgProcessor;
import com.atlassian.clover.api.command.HelpBuilder;
import com.atlassian.clover.cfg.instr.java.JavaInstrumentationConfig;
import com.atlassian.clover.cmdline.CloverInstrArgProcessors;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.instr.java.Instrumenter;
import com.atlassian.clover.util.FileUtils;
import com.atlassian.clover.util.SourceScanner;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.openclover.util.Lists;

public class CloverInstr {
    private static final List<ArgProcessor<JavaInstrumentationConfig>> mandatoryArgProcessors = Lists.newArrayList(CloverInstrArgProcessors.SrcDir, CloverInstrArgProcessors.DestDir);
    private static final List<ArgProcessor<JavaInstrumentationConfig>> optionalArgProcessors = Lists.newArrayList(CloverInstrArgProcessors.InitString, CloverInstrArgProcessors.DistributedCoverage, CloverInstrArgProcessors.Relative, CloverInstrArgProcessors.FlushPolicy, CloverInstrArgProcessors.FlushInterval, CloverInstrArgProcessors.Encoding, CloverInstrArgProcessors.InstrStrategy, CloverInstrArgProcessors.InstrLevel, CloverInstrArgProcessors.InstrLambda, CloverInstrArgProcessors.SourceLevelArg, CloverInstrArgProcessors.RecordTestResults, CloverInstrArgProcessors.DontQualifyJavaLang, CloverInstrArgProcessors.MethodContext, CloverInstrArgProcessors.MethodWithMetricsContext, CloverInstrArgProcessors.StatementContext, CloverInstrArgProcessors.TestSourceRoot, CloverInstrArgProcessors.TestSourceIncludes, CloverInstrArgProcessors.TestSourceExcludes, CloverInstrArgProcessors.TestSourceClass, CloverInstrArgProcessors.TestSourceMethod, CloverInstrArgProcessors.Verbose, CloverInstrArgProcessors.JavaSourceFile);
    private static final List<ArgProcessor<JavaInstrumentationConfig>> allArgProcessors = Lists.join(mandatoryArgProcessors, optionalArgProcessors);
    private JavaInstrumentationConfig cfg;
    private Logger log = Logger.getInstance();

    private CloverInstr() {
    }

    public static void main(String[] args) {
        System.exit(CloverInstr.mainImpl(args));
    }

    public static int mainImpl(String[] args) {
        CloverStartup.loadLicense(Logger.getInstance());
        CloverInstr instr = new CloverInstr();
        if (!instr.processArgs(args)) {
            return 1;
        }
        return instr.execute();
    }

    public int execute() {
        this.log = Logger.getInstance();
        Instrumenter instr = new Instrumenter(this.log, this.cfg);
        if (this.cfg.getSourceDir() != null) {
            this.cfg.getSourceFiles().addAll(this.scanSrcDir(this.cfg.getSourceDir()));
        }
        try {
            ContextStore.saveCustomContexts(this.cfg);
            instr.startInstrumentation();
        }
        catch (CloverException e) {
            this.log.error("Could not initialise Clover: " + e.getMessage());
            return 1;
        }
        try {
            for (String srcFile : this.cfg.getSourceFiles()) {
                instr.instrument(new File(srcFile), this.cfg.getDestDir(), this.cfg.getEncoding());
            }
            instr.endInstrumentation();
        }
        catch (Exception e) {
            this.log.error("Instrumentation error", e);
            return 1;
        }
        return 0;
    }

    private List<String> scanSrcDir(final File dir) throws IOException {
        final ArrayList<String> files = Lists.newArrayList();
        SourceScanner scanner = new SourceScanner(dir, ".*\\.java");
        scanner.visit(new SourceScanner.Visitor(){

            @Override
            public void common(String path) {
                files.add(new File(dir, FileUtils.getNormalizedPath(path)).getAbsolutePath());
            }

            @Override
            public void onlyInSrc(String path) {
                files.add(new File(dir, FileUtils.getNormalizedPath(path)).getAbsolutePath());
            }

            @Override
            public void onlyInDest(String path) {
            }
        });
        return files;
    }

    private static void usage(PrintStream out, String msg) {
        out.println();
        if (msg != null) {
            out.println("  *** ERROR: " + msg);
        }
        out.println(HelpBuilder.buildHelp(CloverInstr.class, mandatoryArgProcessors, optionalArgProcessors));
    }

    private static void usage(String msg) {
        CloverInstr.usage(System.err, msg);
    }

    private boolean processArgs(String[] args) {
        this.cfg = new JavaInstrumentationConfig();
        try {
            int i = 0;
            while (i < args.length) {
                boolean matched = false;
                for (ArgProcessor<JavaInstrumentationConfig> argProcessor : allArgProcessors) {
                    if (!argProcessor.matches(args, i)) continue;
                    i = argProcessor.process(args, i, this.cfg);
                    matched = true;
                    break;
                }
                if (!matched) {
                    System.err.println("  *** WARN: Unknown option: " + args[i]);
                }
                ++i;
            }
            if (!this.cfg.validate()) {
                CloverInstr.usage(this.cfg.getValidationFailureReason());
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            CloverInstr.usage("Missing a parameter.");
            return false;
        }
        return true;
    }
}

