/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import com.atlassian.clover.ant.tasks.TestSourceSet;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.instr.InstrumentationConfig;
import com.atlassian.clover.cfg.instr.InstrumentationLevel;
import com.atlassian.clover.cfg.instr.InstrumentationPlacement;
import com.atlassian.clover.cfg.instr.java.JavaInstrumentationConfig;
import com.atlassian.clover.cfg.instr.java.LambdaInstrumentation;
import com.atlassian.clover.util.ArrayUtil;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Lists;
import org.openclover.util.Sets;

public class AntInstrumentationConfig
extends JavaInstrumentationConfig {
    private final transient Project project;
    protected transient List<FileSet> instrFilesets = null;
    protected transient List<TestSourceSet> testSources = null;
    private transient PatternSet instrPattern;
    private boolean preserve;
    private String compilerDelegate;
    private File groverJar;
    private boolean skipGroverJar = false;

    public AntInstrumentationConfig(Project project) {
        this.project = project;
        this.setProjectName(project.getName());
        this.setDefaultBaseDir(project.getBaseDir());
        this.setInitstring(project.getProperty("clover.initstring"));
    }

    @Override
    public String resolveInitString() {
        File initStringFile;
        File initParent;
        if (this.getInitString() == null) {
            AntInstrumentationConfig cfg = (AntInstrumentationConfig)this.project.getReference("clover.config");
            String initString = null;
            if (cfg != null) {
                initString = cfg.getInitString();
            }
            if (initString == null) {
                initString = this.project.getProperty("clover.initstring");
                if (initString == null) {
                    try {
                        this.createDefaultInitStringDir();
                    }
                    catch (CloverException e) {
                        throw new BuildException(String.valueOf(e.getMessage()) + " Please use the \"initstring\" attribute to specify a Clover database location.");
                    }
                } else {
                    this.setInitstring(initString);
                }
            } else {
                this.setInitstring(initString);
            }
        }
        String resolvedInitString = this.getInitString();
        if (this.project != null && (initParent = (initStringFile = this.project.resolveFile(this.getInitString())).getParentFile()) != null && initParent.exists()) {
            resolvedInitString = initStringFile.getAbsolutePath();
        }
        return resolvedInitString;
    }

    public boolean isPreserve() {
        return this.preserve;
    }

    public void setPreserve(boolean preserve) {
        this.preserve = preserve;
    }

    public String getCompilerDelegate() {
        return this.compilerDelegate;
    }

    public void setCompilerDelegate(String compilerDelegate) {
        this.compilerDelegate = compilerDelegate;
    }

    @Nullable
    public static AntInstrumentationConfig getFrom(@NotNull Project project) {
        return (AntInstrumentationConfig)project.getReference("clover.config");
    }

    public void setIn(Project project) {
        project.addReference("clover.config", (Object)this);
    }

    public void addConfiguredFileSet(FileSet set) {
        if (this.instrFilesets == null) {
            this.instrFilesets = Lists.newArrayList();
        }
        this.instrFilesets.add(set);
    }

    public void addConfiguredTestSources(TestSourceSet testSourceSet) {
        if (this.testSources == null) {
            this.testSources = Lists.newArrayList();
        }
        testSourceSet.validate();
        this.testSources.add(testSourceSet);
    }

    public List<FileSet> getInstrFilesets() {
        return this.instrFilesets;
    }

    public List<TestSourceSet> getTestSources() {
        return this.testSources;
    }

    public void setInstrumentLambda(String instrumentLambda) {
        super.setInstrumentLambda(LambdaInstrumentation.valueOf(instrumentLambda.toUpperCase(Locale.ENGLISH)));
    }

    public void setInstrPattern(PatternSet filesPattern) {
        this.instrPattern = filesPattern;
    }

    public PatternSet getInstrPattern() {
        return this.instrPattern;
    }

    public void setGroverJar(File groverJar) {
        this.groverJar = groverJar;
    }

    public File getGroverJar() {
        return this.groverJar;
    }

    public void setSkipGroverJar(boolean skip) {
        this.skipGroverJar = skip;
    }

    public boolean isSkipGroverJar() {
        return this.skipGroverJar;
    }

    public void configureIncludedFiles() {
        if (this.instrFilesets != null) {
            HashSet<File> includedFiles = Sets.newHashSet();
            for (FileSet fileset : this.instrFilesets) {
                String[] included;
                String[] stringArray = included = fileset.getDirectoryScanner(this.project).getIncludedFiles();
                int n = included.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    includedFiles.add(new File(fileset.getDir(this.project), path));
                    ++n2;
                }
            }
            this.setIncludedFiles(includedFiles);
        }
    }

    public static class EnumInstrumentationLevel
    extends EnumeratedAttribute {
        public String[] getValues() {
            InstrumentationLevel[] levels = InstrumentationLevel.values();
            String[] values = new String[levels.length];
            int i = 0;
            while (i < levels.length) {
                values[i] = levels[i].name().toLowerCase();
                ++i;
            }
            return values;
        }
    }

    public static class FlushPolicy
    extends EnumeratedAttribute {
        public String[] getValues() {
            return InstrumentationConfig.FLUSH_VALUES;
        }
    }

    public static class Instrumentation
    extends EnumeratedAttribute {
        public String[] getValues() {
            return ArrayUtil.toLowerCaseStringArray((Object[])InstrumentationPlacement.values());
        }
    }
}

