/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.AntLogger;
import com.atlassian.clover.ant.tasks.AbstractCloverTask;
import com.atlassian.clover.ant.tasks.CloverReportTask;
import com.atlassian.clover.ant.tasks.FilesetFilter;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.xml.XMLReporter;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;

public class HistoryPointTask
extends AbstractCloverTask {
    private File historyDir;
    private String dateString;
    private String dateFormat;
    private Interval span = Interval.DEFAULT_SPAN;
    private String filter;
    private String property;
    private boolean overwrite = false;
    private final CloverReportTask.CurrentEx config = new CloverReportTask.CurrentEx();
    private boolean alwaysReport = false;
    private boolean srcLevel = true;

    public void setHistoryDir(File historyDir) {
        this.historyDir = historyDir;
    }

    public void setDate(String dateString) {
        this.dateString = dateString;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setSpan(Interval span) {
        this.span = span;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void addFileSet(FileSet fileset) {
        this.config.addFileSet(fileset);
    }

    public void addTestSources(FileSet fileset) {
        this.config.addTestSources(fileset);
    }

    public void addTestResults(FileSet fileset) {
        this.config.addTestResults(fileset);
    }

    public void setIncludeFailedTestCoverage(boolean include) {
        this.config.setIncludeFailedTestCoverage(include);
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setAlwaysReport(boolean alwaysReport) {
        this.alwaysReport = alwaysReport;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setSrcLevel(boolean srcLevel) {
        this.srcLevel = srcLevel;
    }

    @Override
    public void cloverExecute() {
        SimpleDateFormat format;
        String initString = this.resolveInitString();
        if (this.historyDir == null) {
            throw new BuildException("You must specify a directory for the historical information using the \"historydir\" attribute");
        }
        if (this.dateFormat == null) {
            format = new SimpleDateFormat();
        } else {
            try {
                format = new SimpleDateFormat(this.dateFormat);
            }
            catch (IllegalArgumentException e) {
                throw new BuildException("The format \"" + this.dateFormat + "\" is not a valid date format", (Throwable)e);
            }
        }
        this.historyDir.mkdirs();
        Date reportDate = null;
        if (this.dateString != null) {
            try {
                reportDate = format.parse(this.dateString);
            }
            catch (ParseException e) {
                throw new BuildException("The date \"" + this.dateString + "\" is not valid according to the date format \"" + format.toPattern() + "\"", (Throwable)e);
            }
        }
        Format fmt = new Format(Format.DEFAULT_XML);
        if (this.filter != null) {
            fmt.setFilter(this.filter);
        }
        fmt.setSrcLevel(this.srcLevel);
        this.config.setFormat(fmt);
        this.config.setInitString(initString);
        this.config.setEffectiveDate(reportDate);
        this.config.setSpan(this.span);
        this.config.setAlwaysReport(this.alwaysReport);
        this.config.setLoadPerTestData(!this.config.isIncludeFailedTestCoverage());
        if (this.config.getFilesets().size() > 0) {
            this.config.setIncludeFilter(new FilesetFilter(this.getProject(), this.config.getFilesets()));
        }
        Logger.setInstance(new AntLogger(this.getProject(), this));
        this.config.resolve(this.getProject());
        try {
            SimpleDateFormat formatter;
            String tag;
            File outfile;
            CloverReportTask.checkTestSourceFileSet(this.config.getFilesets(), this.config);
            CloverDatabase model = this.config.getCoverageDatabase();
            if (reportDate == null) {
                reportDate = new Date(model.getRecordingTimestamp());
            }
            if ((outfile = new File(this.historyDir, "clover-" + (tag = (formatter = new SimpleDateFormat("yyyyMMddHHmmss")).format(reportDate)) + ".xml.gz")).exists() && !this.overwrite) {
                Logger.getInstance().warn("Not overwriting existing history point '" + outfile.getAbsolutePath() + "'. To force, set overwrite=\"true\".");
                return;
            }
            if (this.property != null) {
                this.getProject().setProperty(this.property, outfile.getAbsolutePath());
            }
            this.config.setOutFile(outfile);
            this.config.setCompress(true);
            new XMLReporter(model, this.config).execute();
        }
        catch (CloverException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

