/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.cmdline;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.instr.tests.AggregateTestDetector;
import com.atlassian.clover.instr.tests.AndStrategy;
import com.atlassian.clover.instr.tests.AntPatternTestDetectorFilter;
import com.atlassian.clover.instr.tests.DefaultTestDetector;
import com.atlassian.clover.instr.tests.OrStrategy;
import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.spec.instr.test.BooleanSpec;
import com.atlassian.clover.spec.instr.test.TestClassSpec;
import com.atlassian.clover.spec.instr.test.TestMethodSpec;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.openclover.util.Objects;

public class FileClassMethodTestDetector
implements TestDetector {
    private TestDetector testDetector;
    private String root;
    private String includePattern;
    private String excludePattern;
    private List<TestClassSpec> testClassSpec = new ArrayList<TestClassSpec>();

    @Override
    public boolean isTypeMatch(TestDetector.SourceContext sourceContext, TestDetector.TypeContext typeContext) {
        return this.getTestDetector().isTypeMatch(sourceContext, typeContext);
    }

    @Override
    public boolean isMethodMatch(TestDetector.SourceContext sourceContext, TestDetector.MethodContext methodContext) {
        return this.getTestDetector().isMethodMatch(sourceContext, methodContext);
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setIncludes(String includePattern) {
        this.includePattern = includePattern;
    }

    public void setExcludes(String excludePattern) {
        this.excludePattern = excludePattern;
    }

    public void addTestClassSpec(TestClassSpec testClassSpec) {
        this.testClassSpec.add(testClassSpec);
    }

    public void addTestMethodSpec(TestMethodSpec testMethodSpec) {
        if (this.testClassSpec.isEmpty()) {
            TestClassSpec anyClassWithMethod = new TestClassSpec();
            this.testClassSpec.add(anyClassWithMethod);
        }
        TestClassSpec lastClassSpec = this.testClassSpec.get(this.testClassSpec.size() - 1);
        lastClassSpec.addConfiguredTestMethod(testMethodSpec);
    }

    private TestDetector getTestDetector() {
        if (this.testDetector == null) {
            this.testDetector = this.buildTestDetector();
        }
        return this.testDetector;
    }

    private TestDetector buildTestDetector() {
        try {
            AntPatternTestDetectorFilter includesExcludesTestDetector = new AntPatternTestDetectorFilter(this.root == null ? new File("") : new File(this.root), this.includePattern == null ? null : this.includePattern.split(","), this.excludePattern == null ? null : this.excludePattern.split(","));
            AggregateTestDetector aggregatedDetector = new AggregateTestDetector(new AndStrategy());
            aggregatedDetector.addDetector(includesExcludesTestDetector);
            if (!this.testClassSpec.isEmpty()) {
                AggregateTestDetector anyOfTheClasses = new AggregateTestDetector(new OrStrategy());
                BooleanSpec.buildTestDetectorFor(anyOfTheClasses, this.testClassSpec);
                aggregatedDetector.addDetector(anyOfTheClasses);
            }
            return aggregatedDetector;
        }
        catch (CloverException cloverException) {
            return new DefaultTestDetector();
        }
    }

    public String toString() {
        return Objects.toStringBuilder(this).add("root", this.root).add("includePattern", this.includePattern).add("excludePattern", this.excludePattern).add("testClassSpec", this.testClassSpec).toString();
    }
}

