/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.context;

import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.context.SimpleContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RegexpContext
extends SimpleContext {
    private Pattern pattern;

    protected RegexpContext(int index, String name, Pattern pattern) {
        super(index, name);
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean matches(String matchString) {
        Matcher m = this.pattern.matcher(matchString);
        return m.matches();
    }

    public boolean isEquivalent(RegexpContext other) {
        return other.getPattern().pattern().equals(this.pattern.pattern());
    }

    @Override
    public NamedContext.Type getType() {
        return NamedContext.Type.REGEXP;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegexpContext that = (RegexpContext)o;
        return this.pattern != null ? this.pattern.pattern().equals(that.pattern.pattern()) : that.pattern == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.pattern != null ? this.pattern.pattern().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + ":" + this.getIndex() + ":" + this.getPattern().pattern();
    }
}

