/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.Logger;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.api.registry.StatementInfo;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.FileElementVisitor;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.FullBranchInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.registry.entities.LineInfo;
import com.atlassian.clover.registry.entities.StackTraceInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.ClassMetrics;
import com.atlassian.clover.registry.metrics.FileMetrics;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.registry.metrics.HasMetricsNode;
import com.atlassian.clover.registry.util.EntityVisitorUtils;
import com.atlassian.clover.spi.lang.Language;
import com.atlassian.clover.util.FileUtils;
import com.atlassian.clover.util.Path;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.openclover.util.Lists;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class FullFileInfo
extends BaseFileInfo
implements CoverageDataReceptor,
FileInfo,
HasMetricsNode,
TaggedPersistent {
    public static final long NO_VERSION = -1L;
    protected Map<String, FullClassInfo> classes = new LinkedHashMap<String, FullClassInfo>();
    protected List<FullStatementInfo> statements = Lists.newArrayList();
    protected List<FullMethodInfo> methods = Lists.newArrayList();
    private File actualFile;
    protected int dataIndex;
    private int dataLength;
    private long minVersion;
    private long maxVersion;
    private transient List orderedClasses;
    private transient LineInfo[] lineInfo;
    private transient Comparator orderby;
    private transient CoverageDataProvider data;
    private transient Map<Integer, List<StackTraceInfo.TraceEntry>> failStackInfos;

    public FullFileInfo(FullPackageInfo containingPackage, File actualFile, String encoding, int dataIndex, int lineCount, int ncLineCount, long timestamp, long filesize, long checksum, long minVersion) {
        super(containingPackage, actualFile.getName(), encoding, lineCount, ncLineCount, timestamp, filesize, checksum);
        this.actualFile = actualFile;
        this.dataIndex = dataIndex;
        this.lineCount = lineCount;
        this.minVersion = this.maxVersion = minVersion;
    }

    private FullFileInfo(File actualFile, String encoding, int dataIndex, int dataLength, int lineCount, int ncLineCount, long timestamp, long checksum, long filesize, long minVersion, long maxVersion, Map<String, FullClassInfo> classes, List<FullMethodInfo> methods, List<FullStatementInfo> statements) {
        super(null, actualFile.getName(), encoding, lineCount, ncLineCount, timestamp, filesize, checksum);
        this.actualFile = actualFile;
        this.dataIndex = dataIndex;
        this.dataLength = dataLength;
        this.lineCount = lineCount;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.classes.putAll(classes);
        this.methods = methods;
        this.statements = statements;
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
        for (FullClassInfo classInfo : this.classes.values()) {
            classInfo.setDataProvider(data);
        }
        for (FullMethodInfo methodInfo : this.methods) {
            methodInfo.setDataProvider(data);
        }
        this.rawMetrics = null;
        this.metrics = null;
    }

    @Override
    public int getDataIndex() {
        return this.dataIndex;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    @NotNull
    public List<? extends ClassInfo> getClasses() {
        return Lists.newArrayList(this.classes.values());
    }

    @Override
    @NotNull
    public List<? extends ClassInfo> getAllClasses() {
        ArrayList allClasses = Lists.newArrayList();
        for (FullClassInfo classInfo : this.classes.values()) {
            allClasses.add(classInfo);
            allClasses.addAll(classInfo.getAllClasses());
        }
        for (FullMethodInfo methodInfo : this.methods) {
            allClasses.addAll(methodInfo.getAllClasses());
        }
        return allClasses;
    }

    @Override
    @NotNull
    public List<? extends MethodInfo> getMethods() {
        return Lists.newArrayList(this.methods);
    }

    @Override
    @NotNull
    public List<? extends MethodInfo> getAllMethods() {
        ArrayList allMethods = Lists.newArrayList();
        for (FullClassInfo classInfo : this.classes.values()) {
            allMethods.addAll(classInfo.getAllMethods());
        }
        for (FullMethodInfo methodInfo : this.methods) {
            allMethods.add(methodInfo);
            allMethods.addAll(methodInfo.getAllMethods());
        }
        return allMethods;
    }

    @Override
    @NotNull
    public List<? extends StatementInfo> getStatements() {
        return Lists.newArrayList(this.statements);
    }

    @Override
    public BlockMetrics getMetrics() {
        if (this.metrics == null || this.getContainingPackage().getContextFilter() != this.contextFilter) {
            this.contextFilter = this.getContainingPackage().getContextFilter();
            this.metrics = this.calcMetrics(true);
        }
        return this.metrics;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(false);
        }
        return this.rawMetrics;
    }

    @Override
    public String getChildType() {
        return "class";
    }

    @Override
    public boolean isEmpty() {
        return this.classes.size() == 0;
    }

    @Override
    public int getNumChildren() {
        return this.classes.size();
    }

    @Override
    public HasMetricsNode getChild(int i) {
        if (this.orderedClasses == null) {
            this.buildOrderedClassList();
        }
        return (HasMetricsNode)this.orderedClasses.get(i);
    }

    @Override
    public int getIndexOfChild(HasMetricsNode child) {
        if (this.orderedClasses == null) {
            this.buildOrderedClassList();
        }
        return this.orderedClasses.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setComparator(Comparator cmp) {
        this.orderby = cmp;
        this.orderedClasses = null;
        for (FullClassInfo classInfo : this.classes.values()) {
            classInfo.setComparator(cmp);
        }
    }

    public File getPhysicalFile() {
        return this.actualFile;
    }

    public boolean validatePhysicalFile() {
        if (this.actualFile.exists()) {
            try {
                return FileUtils.calcAdlerChecksum(this.getPhysicalFile(), this.getEncoding()) == this.getChecksum();
            }
            catch (IOException e) {
                Logger.getInstance().warn("IOException calculating file checksum for " + this.actualFile, e);
            }
        }
        return false;
    }

    public Set<SourceInfo> getSourceRegions() {
        TreeSet<SourceInfo> regions = Sets.newTreeSet(FixedSourceRegion.SOURCE_ORDER_COMP);
        for (ClassInfo classInfo : this.classes.values()) {
            FullClassInfo fullClassInfo = (FullClassInfo)classInfo;
            fullClassInfo.gatherSourceRegions(regions);
        }
        for (MethodInfo methodInfo : this.methods) {
            FullMethodInfo fullMethodInfo = (FullMethodInfo)methodInfo;
            fullMethodInfo.gatherSourceRegions(regions);
        }
        regions.addAll(this.statements);
        return regions;
    }

    public LineInfo[] getLineInfo(boolean showLambdaFunctions, boolean showInnerFunctions) {
        return this.getLineInfo(this.getLineCount() + 1, showLambdaFunctions, showInnerFunctions);
    }

    public LineInfo[] getLineInfo(int ensureLineCountAtLeast, final boolean showLambdaFunctions, final boolean showInnerFunctions) {
        if (this.lineInfo == null) {
            final LineInfo[] tmpLineInfo = new LineInfo[Math.max(this.getLineCount() + 1, ensureLineCountAtLeast)];
            this.visitElements(new FileElementVisitor(){
                final EntityVisitorUtils entityUtils = new EntityVisitorUtils();

                private LineInfo getOrCreateLineInfo(SourceInfo r) {
                    int startLine = r.getStartLine();
                    LineInfo lineInfo = null;
                    if (startLine >= 1 && startLine < tmpLineInfo.length && (lineInfo = tmpLineInfo[startLine]) == null) {
                        tmpLineInfo[startLine] = lineInfo = new LineInfo(startLine);
                    }
                    return lineInfo;
                }

                @Override
                public void visitClass(ClassInfo info) {
                    LineInfo lineInfo = this.getOrCreateLineInfo(info);
                    if (lineInfo != null) {
                        lineInfo.addClassStart((FullClassInfo)info);
                    }
                }

                @Override
                public void visitMethod(MethodInfo info) {
                    LineInfo lineInfo = this.getOrCreateLineInfo(info);
                    if (!(lineInfo == null || !showLambdaFunctions && info.isLambda() || !showInnerFunctions && this.entityUtils.isInnerMethod(info))) {
                        lineInfo.addMethodStart((FullMethodInfo)info);
                    }
                }

                @Override
                public void visitStatement(StatementInfo info) {
                    LineInfo lineInfo = this.getOrCreateLineInfo(info);
                    if (!(lineInfo == null || this.entityUtils.isParentAMethod(info) && (!showLambdaFunctions && this.entityUtils.isParentALambdaMethod(info) || !showInnerFunctions && this.entityUtils.isParentAnInnerMethod(info)))) {
                        lineInfo.addStatement((FullStatementInfo)info);
                    }
                }

                @Override
                public void visitBranch(BranchInfo info) {
                    LineInfo lineInfo = this.getOrCreateLineInfo(info);
                    if (!(lineInfo == null || this.entityUtils.isParentAMethod(info) && (!showLambdaFunctions && this.entityUtils.isParentALambdaMethod(info) || !showInnerFunctions && this.entityUtils.isParentAnInnerMethod(info)))) {
                        lineInfo.addBranch((FullBranchInfo)info);
                    }
                }
            });
            if (this.failStackInfos != null) {
                for (Map.Entry<Integer, List<StackTraceInfo.TraceEntry>> entry : this.failStackInfos.entrySet()) {
                    int line = entry.getKey();
                    List<StackTraceInfo.TraceEntry> stackFrames = entry.getValue();
                    if (line <= 0 || line >= tmpLineInfo.length) continue;
                    if (tmpLineInfo[line] == null) {
                        tmpLineInfo[line] = new LineInfo(line);
                    }
                    tmpLineInfo[line].setFailStackEntries(stackFrames.toArray(new StackTraceInfo.TraceEntry[0]));
                }
            }
            this.lineInfo = tmpLineInfo;
        }
        return this.lineInfo;
    }

    public void visitElements(FileElementVisitor visitor) {
        for (FullClassInfo classInfo : this.classes.values()) {
            classInfo.visitElements(visitor);
        }
    }

    public void resolve(Path path) {
        File resolved = path.resolveFile(this.getPackagePath());
        if (resolved != null) {
            this.actualFile = resolved;
        }
    }

    public void setDataIndex(int dataIndex) {
        this.dataIndex = dataIndex;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public void addVersion(long version) {
        if (this.minVersion == -1L) {
            this.minVersion = version;
        }
        this.maxVersion = Math.max(version, this.maxVersion);
    }

    public void addVersions(long minVersion, long maxVersion) {
        if (this.minVersion == -1L) {
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
        } else {
            this.minVersion = Math.min(this.minVersion, minVersion);
            this.maxVersion = Math.max(this.maxVersion, maxVersion);
        }
    }

    public boolean supportsVersion(long version) {
        return version <= this.maxVersion && version >= this.minVersion;
    }

    public long getMinVersion() {
        return this.minVersion;
    }

    public long getMaxVersion() {
        return this.maxVersion;
    }

    public void resetVersions(long version) {
        this.minVersion = this.maxVersion = version;
    }

    public boolean changedFrom(long checksum, long filesize) {
        return this.getChecksum() != checksum || this.getFilesize() != filesize;
    }

    public void addClass(FullClassInfo classInfo) {
        this.classes.put(classInfo.getName(), classInfo);
    }

    public void addMethod(FullMethodInfo methodInfo) {
        this.methods.add(methodInfo);
    }

    public void addStatement(FullStatementInfo statementInfo) {
        this.statements.add(statementInfo);
    }

    public ClassInfo getNamedClass(String name) {
        return this.classes.get(name);
    }

    public FullFileInfo copy(FullPackageInfo pkg, HasMetricsFilter filter) {
        FullFileInfo file = new FullFileInfo(pkg, this.actualFile, this.encoding, this.dataIndex, this.lineCount, this.ncLineCount, this.timestamp, this.filesize, this.checksum, this.minVersion);
        file.addVersion(this.maxVersion);
        file.setDataProvider(this.getDataProvider());
        for (FullClassInfo classInfo : this.classes.values()) {
            if (!filter.accept(classInfo)) continue;
            file.addClass(classInfo.copy(file, filter));
        }
        for (FullMethodInfo methodInfo : this.methods) {
            if (!filter.accept(methodInfo)) continue;
            file.addMethod(methodInfo.copy(file));
        }
        for (FullStatementInfo statementInfo : this.statements) {
            file.addStatement(statementInfo);
        }
        file.setDataLength(this.getDataLength());
        if (this.failStackInfos != null) {
            file.setFailStackEntries(this.failStackInfos);
        }
        return file;
    }

    public Set<TestCaseInfo> getUniqueFailingTests() {
        HashSet<TestCaseInfo> tests = null;
        if (this.failStackInfos != null) {
            tests = Sets.newHashSet();
            for (Map.Entry<Integer, List<StackTraceInfo.TraceEntry>> entry : this.failStackInfos.entrySet()) {
                List<StackTraceInfo.TraceEntry> entries = entry.getValue();
                for (StackTraceInfo.TraceEntry traceEntry : entries) {
                    tests.add(traceEntry.getParentTrace().getOriginatingTest());
                }
            }
        }
        return tests;
    }

    public Map<Integer, List<StackTraceInfo.TraceEntry>> getFailStackEntries() {
        return this.failStackInfos;
    }

    public void setFailStackEntries(Map<Integer, List<StackTraceInfo.TraceEntry>> entries) {
        this.failStackInfos = new TreeMap<Integer, List<StackTraceInfo.TraceEntry>>(entries);
    }

    public void addFailStackEntry(int lineNum, StackTraceInfo.TraceEntry traceEntry) {
        Integer lineKey;
        List<StackTraceInfo.TraceEntry> tracesForLine;
        if (this.failStackInfos == null) {
            this.failStackInfos = Maps.newTreeMap();
        }
        if ((tracesForLine = this.failStackInfos.get(lineKey = Integer.valueOf(lineNum))) == null) {
            tracesForLine = Lists.newArrayList();
            this.failStackInfos.put(lineKey, tracesForLine);
        }
        tracesForLine.add(traceEntry);
    }

    public Reader getSourceReader() throws IOException {
        if (this.getEncoding() == null) {
            return new FileReader(this.getPhysicalFile());
        }
        return new InputStreamReader(Files.newInputStream(this.getPhysicalFile().toPath(), new OpenOption[0]), this.getEncoding());
    }

    public Language getLanguage() {
        if (this.actualFile != null) {
            Language.Builtin[] builtinArray = Language.Builtin.values();
            int n = builtinArray.length;
            int n2 = 0;
            while (n2 < n) {
                Language.Builtin language = builtinArray[n2];
                for (String extension : language.getFileExtensions()) {
                    if (!this.actualFile.getPath().endsWith(extension)) continue;
                    return language;
                }
                ++n2;
            }
        }
        return null;
    }

    private void buildOrderedClassList() {
        ArrayList<FullClassInfo> tmpOrderedClasses = Lists.newArrayList(this.classes.values());
        if (this.orderby != null) {
            Collections.sort(tmpOrderedClasses, this.orderby);
        } else {
            Collections.sort(tmpOrderedClasses, FixedSourceRegion.SOURCE_ORDER_COMP);
        }
        this.orderedClasses = tmpOrderedClasses;
    }

    private FileMetrics calcMetrics(boolean filtered) {
        FileMetrics fileMetrics = new FileMetrics(this);
        fileMetrics.setLineCount(this.lineCount);
        fileMetrics.setNcLineCount(this.ncLineCount);
        this.calcAndAddClassMetrics(fileMetrics, filtered);
        this.calcAndAddMethodMetrics(fileMetrics, filtered);
        this.calcAndAddStatementMetrics(fileMetrics);
        return fileMetrics;
    }

    private void calcAndAddClassMetrics(FileMetrics fileMetrics, boolean filtered) {
        int numClasses = 0;
        for (FullClassInfo classInfo : this.classes.values()) {
            if (!filtered) {
                fileMetrics.add((ClassMetrics)classInfo.getRawMetrics());
            } else {
                fileMetrics.add((ClassMetrics)classInfo.getMetrics());
            }
            numClasses += 1 + classInfo.getClasses().size();
        }
        fileMetrics.setNumClasses(numClasses);
    }

    private void calcAndAddMethodMetrics(FileMetrics fileMetrics, boolean isFiltered) {
        int covered = 0;
        int numMethods = 0;
        int numTestMethods = 0;
        for (FullMethodInfo methodInfo : this.methods) {
            if (methodInfo.isFiltered(this.contextFilter)) continue;
            if (!isFiltered) {
                fileMetrics.add(methodInfo.getRawMetrics());
            } else {
                fileMetrics.add(methodInfo.getMetrics());
            }
            if (methodInfo.getHitCount() > 0) {
                ++covered;
            }
            if (methodInfo.isTest()) {
                ++numTestMethods;
            }
            ++numMethods;
        }
        fileMetrics.addNumMethods(numMethods);
        fileMetrics.addNumCoveredMethods(covered);
        fileMetrics.addNumTestMethods(numTestMethods);
    }

    private void calcAndAddStatementMetrics(FileMetrics fileMetrics) {
        int covered = 0;
        int numStatements = 0;
        int complexity = 0;
        for (FullStatementInfo statementInfo : this.statements) {
            if (statementInfo.isFiltered(this.contextFilter)) continue;
            if (statementInfo.getHitCount() > 0) {
                ++covered;
            }
            complexity += statementInfo.getComplexity();
            ++numStatements;
        }
        fileMetrics.addNumCoveredStatements(covered);
        fileMetrics.addNumStatements(numStatements);
        fileMetrics.addComplexity(complexity);
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.writeUTF(this.actualFile.getPath());
        out.writeUTF(this.encoding);
        out.writeLong(this.timestamp);
        out.writeLong(this.filesize);
        out.writeLong(this.checksum);
        out.writeInt(this.dataIndex);
        out.writeInt(this.dataLength);
        out.writeLong(this.minVersion);
        out.writeLong(this.maxVersion);
        out.writeInt(this.lineCount);
        out.writeInt(this.ncLineCount);
        out.writeList(FullClassInfo.class, Lists.newArrayList(this.classes.values()));
        out.writeList(FullMethodInfo.class, this.methods);
        out.writeList(FullStatementInfo.class, this.statements);
    }

    public static FullFileInfo read(TaggedDataInput in) throws IOException {
        String actualFileName = FileUtils.getPlatformSpecificPath(in.readUTF());
        File actualFile = new File(actualFileName);
        String encoding = in.readUTF();
        long timestamp = in.readLong();
        long filesize = in.readLong();
        long checksum = in.readLong();
        int dataIndex = in.readInt();
        int dataLength = in.readInt();
        long minVersion = in.readLong();
        long maxVersion = in.readLong();
        int lineCount = in.readInt();
        int ncLineCount = in.readInt();
        Map<String, FullClassInfo> classes = FullFileInfo.readClasses(in);
        List<FullMethodInfo> methods = in.readList(FullMethodInfo.class);
        List<FullStatementInfo> statements = in.readList(FullStatementInfo.class);
        FullFileInfo fileInfo = new FullFileInfo(actualFile, encoding, dataIndex, dataLength, lineCount, ncLineCount, timestamp, checksum, filesize, minVersion, maxVersion, classes, methods, statements);
        for (FullClassInfo classInfo : classes.values()) {
            classInfo.setContainingFile(fileInfo);
        }
        for (FullMethodInfo methodInfo : methods) {
            methodInfo.setContainingFile(fileInfo);
        }
        for (FullStatementInfo statementInfo : statements) {
            statementInfo.setContainingFile(fileInfo);
        }
        return fileInfo;
    }

    private static Map<String, FullClassInfo> readClasses(TaggedDataInput in) throws IOException {
        List<FullClassInfo> classInfos = in.readList(FullClassInfo.class);
        LinkedHashMap<String, FullClassInfo> classes = new LinkedHashMap<String, FullClassInfo>(classInfos.size() * 2);
        for (FullClassInfo classInfo : classInfos) {
            classes.put(classInfo.getName(), classInfo);
        }
        return classes;
    }
}

