/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.json;

import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.html.HtmlRenderingSupportImpl;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.html.RenderFileAction;
import com.atlassian.clover.reporters.html.source.SourceRenderHelper;
import com.atlassian.clover.reporters.json.JSONObject;
import com.atlassian.clover.reporters.json.JSONReportUtils;
import com.atlassian.clover.spi.reporters.html.source.LineRenderInfo;
import com.atlassian.clover.util.CloverUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openclover.util.Lists;

public class RenderFileJSONAction
extends RenderFileAction {
    public RenderFileJSONAction(FullFileInfo fileInfo, HtmlRenderingSupportImpl renderingHelper, Current report, VelocityContext velocity, CloverDatabase database, FullProjectInfo fullModel) {
        super(fileInfo, renderingHelper, report, velocity, database, fullModel, null);
    }

    @Override
    public void render() throws Exception {
        String basename = new File(this.fileInfo.getName()).getName();
        try {
            Map<String, Number> columnValues = JSONReportUtils.collectColumnValuesFor((List)columnsTL.get(), this.fileInfo, this.renderingHelper);
            SourceRenderHelper srh = new SourceRenderHelper(this.database, this.reportConfig, this.renderingHelper);
            FullFileInfo fcopy = this.fileInfo.copy((FullPackageInfo)this.fileInfo.getContainingPackage(), HasMetricsFilter.ACCEPT_ALL);
            LineRenderInfo[] lineInfos = srh.gatherSrcRenderInfo(this.velocity, fcopy, this.getContextSet(), "", this.testLineInfo);
            String apiJsonOutFilename = String.valueOf(RenderFileJSONAction.createOutFileBaseName(basename)) + "java.js";
            File apiJsonOutfile = CloverUtils.createOutFile(fcopy, apiJsonOutFilename, this.reportConfig.getOutFile());
            Collection<String> hitCounts = this.collectHitCounts(lineInfos);
            JSONObject json = new JSONObject();
            json.put("id", this.renderingHelper.getFileIdentifier(fcopy));
            json.put("stats", columnValues);
            json.put("lines", hitCounts);
            this.velocity.put("json", json.toString(2));
            this.velocity.put("callback", this.reportConfig.getFormat().getCallback());
            HtmlReportUtil.mergeTemplateToFile(apiJsonOutfile, this.velocity, "api-json.vm");
        }
        catch (Exception e) {
            Logger.getInstance().error("Invalid Java source found or Clover failed to parse it: " + this.fileInfo.getPhysicalFile().getAbsolutePath(), e);
        }
    }

    private Collection<String> collectHitCounts(LineRenderInfo[] lineInfos) {
        ArrayList<String> hitCounts = Lists.newArrayList();
        LineRenderInfo[] lineRenderInfoArray = lineInfos;
        int n = lineInfos.length;
        int n2 = 0;
        while (n2 < n) {
            LineRenderInfo lineInfo = lineRenderInfoArray[n2];
            hitCounts.add(lineInfo.getCoverageStr());
            ++n2;
        }
        return hitCounts;
    }
}

