/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.util;

import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.cfg.Percentage;
import com.atlassian.clover.model.CoverageDataPoint;
import com.atlassian.clover.model.XmlConverter;
import com.atlassian.clover.registry.entities.BasePackageInfo;
import com.atlassian.clover.registry.entities.BaseProjectInfo;
import com.atlassian.clover.reporters.Column;
import com.atlassian.clover.reporters.Columns;
import com.atlassian.clover.reporters.util.MetricsDiffSummary;
import com.atlassian.clover.util.Formatting;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class HistoricalSupport {
    private static Column DEFAULT_COLUMN = new Columns.TotalPercentageCovered();

    static SortedMap<Long, HasMetrics> getPackageMetricsForRange(String pkgStr, File[] files, long from, long to) {
        List<CoverageDataPoint> modelList = HistoricalSupport.getModelsForRange(files, from, to, 2);
        TreeMap<Long, HasMetrics> result = Maps.newTreeMap();
        for (CoverageDataPoint model : modelList) {
            BaseProjectInfo project = model.getProject();
            BasePackageInfo pkg = project.getNamedPackage(pkgStr);
            if (pkg != null) {
                result.put(project.getVersion(), new HasMetricsWrapper(pkg, model.getDataFile()));
                continue;
            }
            Logger.getInstance().warn("Package " + pkgStr + " not found in historical data at " + Formatting.formatDate(new Date(project.getVersion())));
        }
        return result;
    }

    public static SortedMap<Long, HasMetrics> getAllProjectMetrics(File[] files) throws IOException {
        return HistoricalSupport.getProjectMetricsForRange(files, 0L, Long.MAX_VALUE);
    }

    static SortedMap<Long, HasMetrics> getProjectMetricsForRange(File[] files, long from, long to) {
        List<CoverageDataPoint> modelList = HistoricalSupport.getModelsForRange(files, from, to, 1);
        TreeMap<Long, HasMetrics> result = Maps.newTreeMap();
        for (CoverageDataPoint model : modelList) {
            BaseProjectInfo project = model.getProject();
            result.put(project.getVersion(), new HasMetricsWrapper(project, model.getDataFile()));
        }
        return result;
    }

    public static HasMetrics getFullMetrics(HasMetricsWrapper wrapper, String pkg) throws IOException, CloverException {
        CoverageDataPoint model = XmlConverter.getFromXmlFile(wrapper.getDataFile(), 4);
        if (pkg == null) {
            return model.getProject();
        }
        return model.getProject().getNamedPackage(pkg);
    }

    private static List<CoverageDataPoint> getModelsForRange(File[] files, long from, long to, int level) {
        LinkedList<CoverageDataPoint> models = Lists.newLinkedList();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                CoverageDataPoint model;
                File file = fileArray[n2];
                try {
                    model = XmlConverter.getFromXmlFile(file, level);
                }
                catch (Exception e) {
                    Logger.getInstance().error(String.valueOf(e.getClass().getName()) + " occured processing file " + file, e);
                    Logger.getInstance().error("Error processing file " + file + ", skipped.");
                    break block7;
                }
                if (model.getProject() == null) {
                    Logger.getInstance().warn("File '" + file.getAbsolutePath() + "' does not contain a valid history point. Ignoring.");
                } else {
                    long ts = model.getProject().getVersion();
                    if (ts >= from && ts <= to) {
                        models.add(model);
                    } else {
                        Logger.getInstance().verbose("Snapshot in file " + file + " was outside the specified range.");
                    }
                }
            }
            ++n2;
        }
        Logger.getInstance().info("Read " + models.size() + " history point" + (models.size() == 1 ? "" : "s") + ".");
        Collections.sort(models, CoverageDataPoint.CHRONOLOGICAL_CMP);
        return models;
    }

    public static List<MetricsDiffSummary> getClassesMetricsDifference(HasMetrics then, HasMetrics now, Percentage threshold, boolean onlyDiffs) throws CloverException {
        return HistoricalSupport.getClassesMetricsDifference(then, now, threshold, DEFAULT_COLUMN, onlyDiffs);
    }

    public static List<MetricsDiffSummary> getClassesMetricsDifference(HasMetrics then, HasMetrics now, Percentage threshold, Column column, boolean onlyDiffs) throws CloverException {
        if (then instanceof BasePackageInfo) {
            return HistoricalSupport.getPackageClassesMetricsDiff((BasePackageInfo)then, (BasePackageInfo)now, threshold, column, onlyDiffs);
        }
        return HistoricalSupport.getProjectClassesMetricsDiff((BaseProjectInfo)then, (BaseProjectInfo)now, threshold, column, onlyDiffs);
    }

    public static List<MetricsDiffSummary> getProjectClassesMetricsDiff(BaseProjectInfo then, BaseProjectInfo now, Percentage threshold, Column column, boolean onlyDiffs) throws CloverException {
        LinkedList<MetricsDiffSummary> diffs = Lists.newLinkedList();
        if (onlyDiffs) {
            for (PackageInfo packageInfo : then.getAllPackages()) {
                BasePackageInfo p2 = now.getNamedPackage(packageInfo.getName());
                if (p2 == null) continue;
                Logger.getInstance().debug("diffing classes in package " + packageInfo.getName());
                diffs.addAll(HistoricalSupport.getClassesMetricsDifference(packageInfo, p2, threshold, column, true));
            }
        } else {
            for (PackageInfo packageInfo : now.getAllPackages()) {
                BasePackageInfo p1 = then.getNamedPackage(packageInfo.getName());
                if (p1 != null) {
                    Logger.getInstance().debug("looking for new classes in package " + packageInfo.getName());
                    diffs.addAll(HistoricalSupport.getClassesMetricsDifference(p1, packageInfo, threshold, column, false));
                    continue;
                }
                for (ClassInfo classInfo : packageInfo.getClasses()) {
                    diffs.add(HistoricalSupport.getNewClassMetrics(null, classInfo, column));
                }
            }
        }
        Collections.sort(diffs, MetricsDiffSummary.DIFF_COMP);
        return diffs;
    }

    public static List<MetricsDiffSummary> getPackageClassesMetricsDiff(BasePackageInfo then, BasePackageInfo now, Percentage threshold, Column column, boolean onlyDiffs) throws CloverException {
        if (!then.getName().equals(now.getName())) {
            throw new IllegalArgumentException("Can't compare different packages");
        }
        LinkedList<MetricsDiffSummary> diffs = Lists.newLinkedList();
        if (onlyDiffs) {
            List<? extends ClassInfo> classList = then.getClasses();
            for (ClassInfo classInfo : classList) {
                ClassInfo c2;
                MetricsDiffSummary diff = HistoricalSupport.getClassMetricsDiff(classInfo, c2 = now.getContainingProject().findClass(classInfo.getQualifiedName()), threshold, column);
                if (diff == null) continue;
                diffs.add(diff);
            }
        } else {
            List<? extends ClassInfo> classList = now.getClasses();
            for (ClassInfo classInfo : classList) {
                ClassInfo c1 = then.getContainingProject().findClass(classInfo.getQualifiedName());
                MetricsDiffSummary diff = HistoricalSupport.getNewClassMetrics(c1, classInfo, column);
                if (diff == null) continue;
                diffs.add(diff);
            }
        }
        Collections.sort(diffs, MetricsDiffSummary.DIFF_COMP);
        return diffs;
    }

    public static MetricsDiffSummary getClassMetricsDiff(ClassInfo c1, ClassInfo c2, Percentage threshold, Column column) throws CloverException {
        if (c2 != null) {
            float diff;
            Number pc2;
            Number pc1;
            Logger.getInstance().debug("diffing " + column.getTitle() + " for " + c1.getQualifiedName());
            Column col1 = column.copy();
            Column col2 = column.copy();
            col1.init(c1.getMetrics());
            col2.init(c2.getMetrics());
            if (column.getColumnData() == null) {
                column.init(c1.getMetrics());
            }
            if (col1.getNumber().doubleValue() > column.getNumber().doubleValue()) {
                column.init(c1.getMetrics());
            }
            if (col2.getNumber().doubleValue() > column.getNumber().doubleValue()) {
                column.init(c2.getMetrics());
            }
            if (!(pc1 = col1.getNumber()).equals(pc2 = col2.getNumber())) {
                if (pc1.intValue() == -1) {
                    pc1 = 0;
                } else if (pc2.intValue() == -1) {
                    pc2 = 0;
                }
            }
            if (Math.abs(diff = pc2.floatValue() - pc1.floatValue()) >= threshold.getValue().floatValue()) {
                Logger.getInstance().debug("added " + c1.getQualifiedName());
                return new MetricsDiffSummary(c1, c2, pc1, pc2, diff, column);
            }
        }
        return null;
    }

    public static MetricsDiffSummary getNewClassMetrics(ClassInfo c1, ClassInfo c2, Column column) throws CloverException {
        Column col2 = column.copy();
        col2.init(c2.getMetrics());
        if (column.getColumnData() == null) {
            column.init(c2.getMetrics());
        }
        if (col2.getNumber().doubleValue() > column.getNumber().doubleValue()) {
            column.init(c2.getMetrics());
        }
        if (c1 == null) {
            Logger.getInstance().debug("found new " + column.getTitle() + " for " + c2.getQualifiedName());
            Number pc2 = col2.getNumber();
            Integer pc1 = 100;
            if (pc2.intValue() == -1) {
                pc2 = 0;
            }
            return new MetricsDiffSummary(null, c2, pc1, pc2, pc2.floatValue(), column);
        }
        return null;
    }

    public static class HasMetricsWrapper
    implements HasMetrics {
        private HasMetrics hm;
        public File dataFile;

        public HasMetricsWrapper(HasMetrics hm, File sourceFile) {
            this.hm = hm;
            this.dataFile = sourceFile;
        }

        @Override
        public String getName() {
            return this.hm.getName();
        }

        @Override
        public BlockMetrics getMetrics() {
            return this.hm.getMetrics();
        }

        @Override
        public BlockMetrics getRawMetrics() {
            return this.hm.getRawMetrics();
        }

        public File getDataFile() {
            return this.dataFile;
        }

        @Override
        public void setMetrics(BlockMetrics metrics) {
            this.hm.setMetrics(metrics);
        }
    }
}

