/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ReflectionUtils {
    public static <T> T invokeVirtualImplicit(String method, Object onObj) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ReflectionUtils.invokeVirtualImplicit(method, onObj, new Object[0]);
    }

    public static <T> T invokeVirtualImplicit(String methodName, Object onObj, Object ... withArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[][] argTypesAndNames = ReflectionUtils.classAndNamesFor(withArgs);
        Class<?> clazz = onObj.getClass();
        while (clazz != null) {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (ReflectionUtils.matches(method, methodName, withArgs)) {
                    method.setAccessible(true);
                    return (T)method.invoke(onObj, withArgs);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        throw new NoSuchMethodException("No method found called " + methodName + " accomodating arguments " + Arrays.toString((String[])argTypesAndNames[1]) + " on " + onObj.getClass() + " or its base classes");
    }

    public static <T> T invokeVirtual(String methodName, Object onObj, Class[] declaredArgTypes, Object ... withArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = onObj.getClass();
        while (clazz != null) {
            Method method = clazz.getDeclaredMethod(methodName, declaredArgTypes);
            if (method != null) {
                method.setAccessible(true);
                return (T)method.invoke(onObj, withArgs);
            }
            clazz = clazz.getSuperclass();
        }
        throw new NoSuchMethodException("No method found called " + methodName + " accomodating arguments " + Arrays.toString(declaredArgTypes) + " on " + onObj.getClass() + " or its base classes");
    }

    private static boolean matches(Method method, String methodName, Object[] withArgs) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != withArgs.length) {
            return false;
        }
        int i = 0;
        while (i < paramTypes.length) {
            if (!paramTypes[i].isAssignableFrom(withArgs[i] == null ? paramTypes[i] : withArgs[i].getClass())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Object[][] classAndNamesFor(Object[] args) {
        Class[] argTypes = new Class[args.length];
        String[] argNames = new String[args.length];
        int i = 0;
        while (i < args.length) {
            Object withArg = args[i];
            argTypes[i] = withArg.getClass();
            argNames[i] = withArg.getClass().getCanonicalName();
            ++i;
        }
        return new Object[][]{argTypes, argNames};
    }
}

