/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.ci;

import com.atlassian.clover.api.ci.CIOptions;
import com.atlassian.clover.api.ci.Integrator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openclover.ci.HasPropertyPredicate;
import org.openclover.util.Lists;
import org.openclover.util.Sets;
import org.openclover.util.function.Streams;

public class MavenIntegrator
implements Integrator {
    static final String GROUP_ID = "org.openclover";
    static final String ARTIFACT_ID = "clover-maven-plugin";
    static final String PREFIX = String.format("%s::%s:", "org.openclover", "clover-maven-plugin");
    public static final Set<String> CLOVER_SETUP_NOT_BEFORE = Sets.newHashSet("clean", "jaxb2:generate", "wsdl2java");
    public static final Set<String> CLOVER_OPTIMIZE_BEFORE = Sets.newHashSet("test", "prepare-package", "package", "pre-integration-test", "integration-test", "post-integration-test", "verify", "install", "deploy");
    public static final Set<String> ADD_VERIFY_IF_NONE_PRESENT = Sets.newHashSet("compile", "test", "prepare-package", "package", "pre-integration-test", "integration-test", "post-integration-test", "verify", "install", "deploy");
    private static final String CLOVER_LICENSE = "maven.clover.license";
    private static final String CLOVER_LICENSE_LOCATION = "maven.clover.licenseLocation";
    private static final String CLOVER_GENERATE_XML = "maven.clover.generateXml";
    private static final String CLOVER_GENERATE_PDF = "maven.clover.generatePdf";
    private static final String CLOVER_GENERATE_JSON = "maven.clover.generateJson";
    private static final String CLOVER_GENERATE_HTML = "maven.clover.generateHtml";
    private static final String CLOVER_GENERATE_HISTORICAL = "maven.clover.generateHistorical";
    private final CIOptions options;

    public MavenIntegrator(CIOptions options) {
        this.options = options;
    }

    @Override
    public void decorateArguments(List<String> args) {
        ArrayList<String> newArgs = Lists.newArrayList(args);
        if (this.options.isFullClean() && !newArgs.contains("clean")) {
            newArgs.add(0, "clean");
        }
        MavenIntegrator.insertAfterAllOf(newArgs, CLOVER_SETUP_NOT_BEFORE, String.valueOf(PREFIX) + "setup", true);
        if (this.options.isOptimize()) {
            MavenIntegrator.insertBeforeAnyOf(newArgs, CLOVER_OPTIMIZE_BEFORE, String.valueOf(PREFIX) + "optimize", false);
        }
        if (this.needsVerify(newArgs)) {
            newArgs.add("verify");
        }
        if (this.options.isOptimize()) {
            newArgs.add(String.valueOf(PREFIX) + "snapshot");
        }
        newArgs.add(String.valueOf(PREFIX) + "aggregate");
        newArgs.add(String.valueOf(PREFIX) + "clover");
        this.addHistoricalReportProperties(newArgs);
        this.addReportFormatsProperties(newArgs);
        this.addLicenseProperties(newArgs);
        args.clear();
        args.addAll(newArgs);
    }

    private boolean needsVerify(ArrayList<String> newArgs) {
        boolean needsVerify = true;
        for (String phase : ADD_VERIFY_IF_NONE_PRESENT) {
            if (!newArgs.contains(phase)) continue;
            needsVerify = false;
            break;
        }
        return needsVerify;
    }

    private void addHistoricalReportProperties(ArrayList<String> newArgs) {
        if (this.options.isHistorical() && !this.containsArg(newArgs, CLOVER_GENERATE_HISTORICAL)) {
            String histDir = this.options.getHistoryDir() != null ? this.options.getHistoryDir().getAbsolutePath() : ".cloverhistory";
            this.addProperty(newArgs, CLOVER_GENERATE_HISTORICAL, true);
            this.addProperty(newArgs, "maven.clover.historyDir", histDir);
            newArgs.add(String.valueOf(PREFIX) + "save-history");
        }
    }

    private void addReportFormatsProperties(List<String> args) {
        if (!this.containsArg(args, CLOVER_GENERATE_HTML)) {
            this.addProperty(args, CLOVER_GENERATE_HTML, this.options.isHtml());
        }
        if (!this.containsArg(args, CLOVER_GENERATE_JSON)) {
            this.addProperty(args, CLOVER_GENERATE_JSON, this.options.isJson());
        }
        if (!this.containsArg(args, CLOVER_GENERATE_PDF)) {
            this.addProperty(args, CLOVER_GENERATE_PDF, this.options.isPdf());
        }
        if (!this.containsArg(args, CLOVER_GENERATE_XML)) {
            this.addProperty(args, CLOVER_GENERATE_XML, this.options.isXml());
        }
    }

    private void addLicenseProperties(List<String> args) {
        if (!this.containsArg(args, CLOVER_LICENSE) && this.options.getLicenseCert() != null && !this.options.getLicenseCert().trim().equals("")) {
            this.addProperty(args, CLOVER_LICENSE, this.options.getLicenseCert());
        }
        if (!this.containsArg(args, CLOVER_LICENSE_LOCATION) && this.options.getLicense() != null) {
            this.addProperty(args, CLOVER_LICENSE_LOCATION, this.options.getLicense().getAbsolutePath());
        }
    }

    private void addProperty(List<String> args, String name, String value) {
        args.add(String.format("-D%s=%s", name, value));
    }

    private void addProperty(List<String> args, String name, boolean value) {
        args.add(String.format("-D%s=%b", name, value));
    }

    private boolean containsArg(List<String> args, String property) {
        return Streams.matchesAny(args, new HasPropertyPredicate(property));
    }

    static <T> void insertAfterAllOf(ArrayList<T> list, Set<T> afterAllOf, T element, boolean putIfNotFound) {
        int i = list.size() - 1;
        while (i >= 0) {
            T goal = list.get(i);
            if (afterAllOf.contains(goal)) {
                list.add(i + 1, element);
                break;
            }
            if (i == 0 && putIfNotFound) {
                list.add(0, element);
            }
            --i;
        }
    }

    static <T> void insertBeforeAnyOf(ArrayList<T> list, Set<T> beforeAnyOf, T element, boolean putIfNotFound) {
        int i = 0;
        while (i < list.size()) {
            T goal = list.get(i);
            if (beforeAnyOf.contains(goal)) {
                list.add(i, element);
                break;
            }
            if (i == list.size() - 1 && putIfNotFound) {
                list.add(i + 1, element);
                break;
            }
            ++i;
        }
    }
}

