/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.adapter.contract.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import org.opendatadiscovery.adapter.contract.api.ApiUtil;
import org.opendatadiscovery.adapter.contract.model.DataEntityList;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import springfox.documentation.annotations.ApiIgnore;

@Validated
@Api(value="entities", description="the entities API")
public interface EntitiesApi {
    @ApiOperation(value="", nickname="getDataEntities", notes="Provides list of available entities", response=DataEntityList.class, tags={"OpenDataDiscoveryAdapter"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DataEntityList.class)})
    @GetMapping(value={"/entities"}, produces={"application/json"})
    default public Mono<ResponseEntity<DataEntityList>> getDataEntities(@ApiParam(value="Get data enitites updated after changed_since date") @Valid @RequestParam(value="changed_since", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime changedSince, @ApiIgnore ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"data_source_oddrn\" : \"//aws/glue/123456789010/\", \"items\" : [ null, null ] }";
            result = ApiUtil.getExampleResponse(exchange, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }
}

