/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.adapter.contract.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.opendatadiscovery.adapter.contract.model.MetadataExtension;

public class BaseObject {
    @JsonProperty(value="oddrn")
    private String oddrn;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="metadata")
    @Valid
    private List<MetadataExtension> metadata = null;

    public BaseObject oddrn(String oddrn) {
        this.oddrn = oddrn;
        return this;
    }

    @ApiModelProperty(example="//aws/glue/{account_id}/{database}/{tablename}", required=true, value="")
    @NotNull
    public String getOddrn() {
        return this.oddrn;
    }

    public void setOddrn(String oddrn) {
        this.oddrn = oddrn;
    }

    public BaseObject name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BaseObject version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public BaseObject description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BaseObject owner(String owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(example="//aws/iam/{account_id}/user/name", value="")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public BaseObject metadata(List<MetadataExtension> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BaseObject addMetadataItem(MetadataExtension metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<MetadataExtension>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public List<MetadataExtension> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<MetadataExtension> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseObject baseObject = (BaseObject)o;
        return Objects.equals(this.oddrn, baseObject.oddrn) && Objects.equals(this.name, baseObject.name) && Objects.equals(this.version, baseObject.version) && Objects.equals(this.description, baseObject.description) && Objects.equals(this.owner, baseObject.owner) && Objects.equals(this.metadata, baseObject.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.oddrn, this.name, this.version, this.description, this.owner, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseObject {\n");
        sb.append("    oddrn: ").append(this.toIndentedString(this.oddrn)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

