package org.opendatadiscovery.client.api;

import org.opendatadiscovery.client.ApiClient;

import org.opendatadiscovery.client.model.CompactDataEntityList;
import org.opendatadiscovery.client.model.DataEntityList;
import org.opendatadiscovery.client.model.DataSourceList;
import org.opendatadiscovery.client.model.DatasetStatisticsList;
import org.opendatadiscovery.client.model.IngestionAlertList;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-02-27T13:53:41.971284Z[Etc/UTC]")
public class OpenDataDiscoveryIngestionApi {
    private ApiClient apiClient;

    public OpenDataDiscoveryIngestionApi() {
        this(new ApiClient());
    }

    @Autowired
    public OpenDataDiscoveryIngestionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 
     * Alerts target catalog about ingestion issues
     * <p><b>201</b> - Created
     * @param ingestionAlertList The ingestionAlertList parameter
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAlertsRequestCreation(IngestionAlertList ingestionAlertList) throws WebClientResponseException {
        Object postBody = ingestionAlertList;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/ingestion/alerts", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * 
     * Alerts target catalog about ingestion issues
     * <p><b>201</b> - Created
     * @param ingestionAlertList The ingestionAlertList parameter
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Void> createAlerts(IngestionAlertList ingestionAlertList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return createAlertsRequestCreation(ingestionAlertList).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> createAlertsWithHttpInfo(IngestionAlertList ingestionAlertList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return createAlertsRequestCreation(ingestionAlertList).toEntity(localVarReturnType);
    }
    /**
     * 
     * Creates data sources in the target catalog
     * <p><b>201</b> - Created
     * @param dataSourceList The dataSourceList parameter
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createDataSourceRequestCreation(DataSourceList dataSourceList) throws WebClientResponseException {
        Object postBody = dataSourceList;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/ingestion/datasources", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * 
     * Creates data sources in the target catalog
     * <p><b>201</b> - Created
     * @param dataSourceList The dataSourceList parameter
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Void> createDataSource(DataSourceList dataSourceList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return createDataSourceRequestCreation(dataSourceList).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> createDataSourceWithHttpInfo(DataSourceList dataSourceList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return createDataSourceRequestCreation(dataSourceList).toEntity(localVarReturnType);
    }
    /**
     * 
     * Searches for data entities in the target catalog by oddrn of a DEG they are currently part of
     * <p><b>200</b> - OK
     * @param oddrn The oddrn parameter
     * @return CompactDataEntityList
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getDataEntitiesByDEGOddrnRequestCreation(String oddrn) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'oddrn' is set
        if (oddrn == null) {
            throw new WebClientResponseException("Missing the required parameter 'oddrn' when calling getDataEntitiesByDEGOddrn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "oddrn", oddrn));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<CompactDataEntityList> localVarReturnType = new ParameterizedTypeReference<CompactDataEntityList>() {};
        return apiClient.invokeAPI("/ingestion/entities/degs/children", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * 
     * Searches for data entities in the target catalog by oddrn of a DEG they are currently part of
     * <p><b>200</b> - OK
     * @param oddrn The oddrn parameter
     * @return CompactDataEntityList
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompactDataEntityList> getDataEntitiesByDEGOddrn(String oddrn) throws WebClientResponseException {
        ParameterizedTypeReference<CompactDataEntityList> localVarReturnType = new ParameterizedTypeReference<CompactDataEntityList>() {};
        return getDataEntitiesByDEGOddrnRequestCreation(oddrn).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<CompactDataEntityList>> getDataEntitiesByDEGOddrnWithHttpInfo(String oddrn) throws WebClientResponseException {
        ParameterizedTypeReference<CompactDataEntityList> localVarReturnType = new ParameterizedTypeReference<CompactDataEntityList>() {};
        return getDataEntitiesByDEGOddrnRequestCreation(oddrn).toEntity(localVarReturnType);
    }
    /**
     * 
     * Ingests list of data entities
     * <p><b>201</b> - Created
     * @param dataEntityList The dataEntityList parameter
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec postDataEntityListRequestCreation(DataEntityList dataEntityList) throws WebClientResponseException {
        Object postBody = dataEntityList;
        // verify the required parameter 'dataEntityList' is set
        if (dataEntityList == null) {
            throw new WebClientResponseException("Missing the required parameter 'dataEntityList' when calling postDataEntityList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/ingestion/entities", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * 
     * Ingests list of data entities
     * <p><b>201</b> - Created
     * @param dataEntityList The dataEntityList parameter
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Void> postDataEntityList(DataEntityList dataEntityList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return postDataEntityListRequestCreation(dataEntityList).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> postDataEntityListWithHttpInfo(DataEntityList dataEntityList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return postDataEntityListRequestCreation(dataEntityList).toEntity(localVarReturnType);
    }
    /**
     * 
     * Ingests list of stats for data sets
     * <p><b>201</b> - Created
     * @param datasetStatisticsList The datasetStatisticsList parameter
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec postDataSetStatsListRequestCreation(DatasetStatisticsList datasetStatisticsList) throws WebClientResponseException {
        Object postBody = datasetStatisticsList;
        // verify the required parameter 'datasetStatisticsList' is set
        if (datasetStatisticsList == null) {
            throw new WebClientResponseException("Missing the required parameter 'datasetStatisticsList' when calling postDataSetStatsList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/ingestion/entities/datasets/stats", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * 
     * Ingests list of stats for data sets
     * <p><b>201</b> - Created
     * @param datasetStatisticsList The datasetStatisticsList parameter
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Void> postDataSetStatsList(DatasetStatisticsList datasetStatisticsList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return postDataSetStatsListRequestCreation(datasetStatisticsList).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> postDataSetStatsListWithHttpInfo(DatasetStatisticsList datasetStatisticsList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return postDataSetStatsListRequestCreation(datasetStatisticsList).toEntity(localVarReturnType);
    }
}
