/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opendatadiscovery.client.model.Metric;
import org.opendatadiscovery.client.model.MetricType;

@JsonPropertyOrder(value={"name", "type", "unit", "help", "metrics"})
@JsonTypeName(value="MetricFamily")
public class MetricFamily {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    private MetricType type;
    public static final String JSON_PROPERTY_UNIT = "unit";
    private String unit;
    public static final String JSON_PROPERTY_HELP = "help";
    private String help;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private List<Metric> metrics = new ArrayList<Metric>();

    public MetricFamily name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public MetricFamily type(MetricType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MetricType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(MetricType type) {
        this.type = type;
    }

    public MetricFamily unit(String unit) {
        this.unit = unit;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="unit")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUnit() {
        return this.unit;
    }

    @JsonProperty(value="unit")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUnit(String unit) {
        this.unit = unit;
    }

    public MetricFamily help(String help) {
        this.help = help;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="help")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHelp() {
        return this.help;
    }

    @JsonProperty(value="help")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHelp(String help) {
        this.help = help;
    }

    public MetricFamily metrics(List<Metric> metrics) {
        this.metrics = metrics;
        return this;
    }

    public MetricFamily addMetricsItem(Metric metricsItem) {
        this.metrics.add(metricsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Metric> getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricFamily metricFamily = (MetricFamily)o;
        return Objects.equals(this.name, metricFamily.name) && Objects.equals((Object)this.type, (Object)metricFamily.type) && Objects.equals(this.unit, metricFamily.unit) && Objects.equals(this.help, metricFamily.help) && Objects.equals(this.metrics, metricFamily.metrics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.unit, this.help, this.metrics});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricFamily {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    help: ").append(this.toIndentedString(this.help)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

