/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opendatadiscovery.client.model.DataRelationshipDetails;

@JsonPropertyOrder(value={"relationship_type", "source_dataset_oddrn", "target_dataset_oddrn", "details"})
public class DataRelationship {
    public static final String JSON_PROPERTY_RELATIONSHIP_TYPE = "relationship_type";
    private RelationshipTypeEnum relationshipType;
    public static final String JSON_PROPERTY_SOURCE_DATASET_ODDRN = "source_dataset_oddrn";
    private String sourceDatasetOddrn;
    public static final String JSON_PROPERTY_TARGET_DATASET_ODDRN = "target_dataset_oddrn";
    private String targetDatasetOddrn;
    public static final String JSON_PROPERTY_DETAILS = "details";
    private DataRelationshipDetails details;

    public DataRelationship relationshipType(RelationshipTypeEnum relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="relationship_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RelationshipTypeEnum getRelationshipType() {
        return this.relationshipType;
    }

    @JsonProperty(value="relationship_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRelationshipType(RelationshipTypeEnum relationshipType) {
        this.relationshipType = relationshipType;
    }

    public DataRelationship sourceDatasetOddrn(String sourceDatasetOddrn) {
        this.sourceDatasetOddrn = sourceDatasetOddrn;
        return this;
    }

    @Nonnull
    @JsonProperty(value="source_dataset_oddrn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceDatasetOddrn() {
        return this.sourceDatasetOddrn;
    }

    @JsonProperty(value="source_dataset_oddrn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceDatasetOddrn(String sourceDatasetOddrn) {
        this.sourceDatasetOddrn = sourceDatasetOddrn;
    }

    public DataRelationship targetDatasetOddrn(String targetDatasetOddrn) {
        this.targetDatasetOddrn = targetDatasetOddrn;
        return this;
    }

    @Nonnull
    @JsonProperty(value="target_dataset_oddrn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTargetDatasetOddrn() {
        return this.targetDatasetOddrn;
    }

    @JsonProperty(value="target_dataset_oddrn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTargetDatasetOddrn(String targetDatasetOddrn) {
        this.targetDatasetOddrn = targetDatasetOddrn;
    }

    public DataRelationship details(DataRelationshipDetails details) {
        this.details = details;
        return this;
    }

    @Nonnull
    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DataRelationshipDetails getDetails() {
        return this.details;
    }

    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDetails(DataRelationshipDetails details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataRelationship dataRelationship = (DataRelationship)o;
        return Objects.equals((Object)this.relationshipType, (Object)dataRelationship.relationshipType) && Objects.equals(this.sourceDatasetOddrn, dataRelationship.sourceDatasetOddrn) && Objects.equals(this.targetDatasetOddrn, dataRelationship.targetDatasetOddrn) && Objects.equals(this.details, dataRelationship.details);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.relationshipType, this.sourceDatasetOddrn, this.targetDatasetOddrn, this.details});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataRelationship {\n");
        sb.append("    relationshipType: ").append(this.toIndentedString((Object)this.relationshipType)).append("\n");
        sb.append("    sourceDatasetOddrn: ").append(this.toIndentedString(this.sourceDatasetOddrn)).append("\n");
        sb.append("    targetDatasetOddrn: ").append(this.toIndentedString(this.targetDatasetOddrn)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RelationshipTypeEnum {
        ERD("ERD"),
        GRAPH("GRAPH");

        private String value;

        private RelationshipTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RelationshipTypeEnum fromValue(String value) {
            for (RelationshipTypeEnum b : RelationshipTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

