/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class CustomS3Path
implements OddrnPath {
    @PathField
    private final String endpoint;
    @PathField(dependency={"endpoint"}, prefix="buckets")
    private final String bucket;
    @PathField(dependency={"bucket"}, prefix="keys")
    private final String key;

    @Override
    public String prefix() {
        return "//s3-custom";
    }

    CustomS3Path(String endpoint, String bucket, String key) {
        this.endpoint = endpoint;
        this.bucket = bucket;
        this.key = key;
    }

    public static CustomS3PathBuilder builder() {
        return new CustomS3PathBuilder();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomS3Path)) {
            return false;
        }
        CustomS3Path other = (CustomS3Path)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomS3Path;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public String toString() {
        return "CustomS3Path(endpoint=" + this.getEndpoint() + ", bucket=" + this.getBucket() + ", key=" + this.getKey() + ")";
    }

    public static class CustomS3PathBuilder {
        private String endpoint;
        private String bucket;
        private String key;

        CustomS3PathBuilder() {
        }

        public CustomS3PathBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public CustomS3PathBuilder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public CustomS3PathBuilder key(String key) {
            this.key = key;
            return this;
        }

        public CustomS3Path build() {
            return new CustomS3Path(this.endpoint, this.bucket, this.key);
        }

        public String toString() {
            return "CustomS3Path.CustomS3PathBuilder(endpoint=" + this.endpoint + ", bucket=" + this.bucket + ", key=" + this.key + ")";
        }
    }
}

