/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class FilesystemPathModel
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="paths", dependency={"host"})
    private final String path;
    @PathField(prefix="fields", dependency={"path"})
    private final String field;

    @Override
    public String prefix() {
        return "//filesystem";
    }

    @Override
    public String name() {
        return "filesystem";
    }

    FilesystemPathModel(String host, String path, String field) {
        this.host = host;
        this.path = path;
        this.field = field;
    }

    public static FilesystemPathModelBuilder builder() {
        return new FilesystemPathModelBuilder();
    }

    public FilesystemPathModelBuilder toBuilder() {
        return new FilesystemPathModelBuilder().host(this.host).path(this.path).field(this.field);
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getField() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilesystemPathModel)) {
            return false;
        }
        FilesystemPathModel other = (FilesystemPathModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        return !(this$field == null ? other$field != null : !this$field.equals(other$field));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FilesystemPathModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        return result;
    }

    public String toString() {
        return "FilesystemPathModel(host=" + this.getHost() + ", path=" + this.getPath() + ", field=" + this.getField() + ")";
    }

    public static class FilesystemPathModelBuilder {
        private String host;
        private String path;
        private String field;

        FilesystemPathModelBuilder() {
        }

        public FilesystemPathModelBuilder host(String host) {
            this.host = host;
            return this;
        }

        public FilesystemPathModelBuilder path(String path) {
            this.path = path;
            return this;
        }

        public FilesystemPathModelBuilder field(String field) {
            this.field = field;
            return this;
        }

        public FilesystemPathModel build() {
            return new FilesystemPathModel(this.host, this.path, this.field);
        }

        public String toString() {
            return "FilesystemPathModel.FilesystemPathModelBuilder(host=" + this.host + ", path=" + this.path + ", field=" + this.field + ")";
        }
    }
}

