/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class KubeflowPathsModel
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="pipelines", dependency={"host"})
    private final String pipeline;
    @PathField(prefix="experiments", dependency={"host"})
    private final String experiment;
    @PathField(prefix="runs", dependency={"experiment"})
    private final String run;

    @Override
    public String prefix() {
        return "//kubeflow";
    }

    @Override
    public String name() {
        return "kubeflow";
    }

    KubeflowPathsModel(String host, String pipeline, String experiment, String run) {
        this.host = host;
        this.pipeline = pipeline;
        this.experiment = experiment;
        this.run = run;
    }

    public static KubeflowPathsModelBuilder builder() {
        return new KubeflowPathsModelBuilder();
    }

    public KubeflowPathsModelBuilder toBuilder() {
        return new KubeflowPathsModelBuilder().host(this.host).pipeline(this.pipeline).experiment(this.experiment).run(this.run);
    }

    public String getHost() {
        return this.host;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public String getExperiment() {
        return this.experiment;
    }

    public String getRun() {
        return this.run;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubeflowPathsModel)) {
            return false;
        }
        KubeflowPathsModel other = (KubeflowPathsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$pipeline = this.getPipeline();
        String other$pipeline = other.getPipeline();
        if (this$pipeline == null ? other$pipeline != null : !this$pipeline.equals(other$pipeline)) {
            return false;
        }
        String this$experiment = this.getExperiment();
        String other$experiment = other.getExperiment();
        if (this$experiment == null ? other$experiment != null : !this$experiment.equals(other$experiment)) {
            return false;
        }
        String this$run = this.getRun();
        String other$run = other.getRun();
        return !(this$run == null ? other$run != null : !this$run.equals(other$run));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubeflowPathsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $pipeline = this.getPipeline();
        result = result * 59 + ($pipeline == null ? 43 : $pipeline.hashCode());
        String $experiment = this.getExperiment();
        result = result * 59 + ($experiment == null ? 43 : $experiment.hashCode());
        String $run = this.getRun();
        result = result * 59 + ($run == null ? 43 : $run.hashCode());
        return result;
    }

    public String toString() {
        return "KubeflowPathsModel(host=" + this.getHost() + ", pipeline=" + this.getPipeline() + ", experiment=" + this.getExperiment() + ", run=" + this.getRun() + ")";
    }

    public static class KubeflowPathsModelBuilder {
        private String host;
        private String pipeline;
        private String experiment;
        private String run;

        KubeflowPathsModelBuilder() {
        }

        public KubeflowPathsModelBuilder host(String host) {
            this.host = host;
            return this;
        }

        public KubeflowPathsModelBuilder pipeline(String pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public KubeflowPathsModelBuilder experiment(String experiment) {
            this.experiment = experiment;
            return this;
        }

        public KubeflowPathsModelBuilder run(String run) {
            this.run = run;
            return this;
        }

        public KubeflowPathsModel build() {
            return new KubeflowPathsModel(this.host, this.pipeline, this.experiment, this.run);
        }

        public String toString() {
            return "KubeflowPathsModel.KubeflowPathsModelBuilder(host=" + this.host + ", pipeline=" + this.pipeline + ", experiment=" + this.experiment + ", run=" + this.run + ")";
        }
    }
}

