/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class PrefectPath
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="projects", dependency={"host"})
    private final String project;
    @PathField(prefix="flows", dependency={"project"})
    private final String flow;
    @PathField(prefix="tasks", dependency={"flow"})
    private final String task;
    @PathField(prefix="runs", dependency={"task"})
    private final String run;

    @Override
    public String prefix() {
        return "//prefect";
    }

    @Override
    public String name() {
        return "prefect";
    }

    PrefectPath(String host, String project, String flow, String task, String run) {
        this.host = host;
        this.project = project;
        this.flow = flow;
        this.task = task;
        this.run = run;
    }

    public static PrefectPathBuilder builder() {
        return new PrefectPathBuilder();
    }

    public PrefectPathBuilder toBuilder() {
        return new PrefectPathBuilder().host(this.host).project(this.project).flow(this.flow).task(this.task).run(this.run);
    }

    public String getHost() {
        return this.host;
    }

    public String getProject() {
        return this.project;
    }

    public String getFlow() {
        return this.flow;
    }

    public String getTask() {
        return this.task;
    }

    public String getRun() {
        return this.run;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrefectPath)) {
            return false;
        }
        PrefectPath other = (PrefectPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        String this$task = this.getTask();
        String other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        String this$run = this.getRun();
        String other$run = other.getRun();
        return !(this$run == null ? other$run != null : !this$run.equals(other$run));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrefectPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        String $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        String $run = this.getRun();
        result = result * 59 + ($run == null ? 43 : $run.hashCode());
        return result;
    }

    public String toString() {
        return "PrefectPath(host=" + this.getHost() + ", project=" + this.getProject() + ", flow=" + this.getFlow() + ", task=" + this.getTask() + ", run=" + this.getRun() + ")";
    }

    public static class PrefectPathBuilder {
        private String host;
        private String project;
        private String flow;
        private String task;
        private String run;

        PrefectPathBuilder() {
        }

        public PrefectPathBuilder host(String host) {
            this.host = host;
            return this;
        }

        public PrefectPathBuilder project(String project) {
            this.project = project;
            return this;
        }

        public PrefectPathBuilder flow(String flow) {
            this.flow = flow;
            return this;
        }

        public PrefectPathBuilder task(String task) {
            this.task = task;
            return this;
        }

        public PrefectPathBuilder run(String run) {
            this.run = run;
            return this;
        }

        public PrefectPath build() {
            return new PrefectPath(this.host, this.project, this.flow, this.task, this.run);
        }

        public String toString() {
            return "PrefectPath.PrefectPathBuilder(host=" + this.host + ", project=" + this.project + ", flow=" + this.flow + ", task=" + this.task + ", run=" + this.run + ")";
        }
    }
}

