/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class RedashPathsModel
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="queries", dependency={"host"})
    private final String query;
    @PathField(prefix="dashboards", dependency={"host"})
    private final String dashboard;

    @Override
    public String prefix() {
        return "//redash";
    }

    @Override
    public String name() {
        return "redash";
    }

    RedashPathsModel(String host, String query, String dashboard) {
        this.host = host;
        this.query = query;
        this.dashboard = dashboard;
    }

    public static RedashPathsModelBuilder builder() {
        return new RedashPathsModelBuilder();
    }

    public RedashPathsModelBuilder toBuilder() {
        return new RedashPathsModelBuilder().host(this.host).query(this.query).dashboard(this.dashboard);
    }

    public String getHost() {
        return this.host;
    }

    public String getQuery() {
        return this.query;
    }

    public String getDashboard() {
        return this.dashboard;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedashPathsModel)) {
            return false;
        }
        RedashPathsModel other = (RedashPathsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$dashboard = this.getDashboard();
        String other$dashboard = other.getDashboard();
        return !(this$dashboard == null ? other$dashboard != null : !this$dashboard.equals(other$dashboard));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedashPathsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $dashboard = this.getDashboard();
        result = result * 59 + ($dashboard == null ? 43 : $dashboard.hashCode());
        return result;
    }

    public String toString() {
        return "RedashPathsModel(host=" + this.getHost() + ", query=" + this.getQuery() + ", dashboard=" + this.getDashboard() + ")";
    }

    public static class RedashPathsModelBuilder {
        private String host;
        private String query;
        private String dashboard;

        RedashPathsModelBuilder() {
        }

        public RedashPathsModelBuilder host(String host) {
            this.host = host;
            return this;
        }

        public RedashPathsModelBuilder query(String query) {
            this.query = query;
            return this;
        }

        public RedashPathsModelBuilder dashboard(String dashboard) {
            this.dashboard = dashboard;
            return this;
        }

        public RedashPathsModel build() {
            return new RedashPathsModel(this.host, this.query, this.dashboard);
        }

        public String toString() {
            return "RedashPathsModel.RedashPathsModelBuilder(host=" + this.host + ", query=" + this.query + ", dashboard=" + this.dashboard + ")";
        }
    }
}

