/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class AwsS3Path
implements OddrnPath {
    @PathField(prefix="buckets")
    private final String bucket;
    @PathField(prefix="keys", dependency={"bucket"})
    private final String key;

    @Override
    public String prefix() {
        return "//s3/cloud/aws";
    }

    @Override
    public String name() {
        return "aws_s3";
    }

    AwsS3Path(String bucket, String key) {
        this.bucket = bucket;
        this.key = key;
    }

    public static AwsS3PathBuilder builder() {
        return new AwsS3PathBuilder();
    }

    public AwsS3PathBuilder toBuilder() {
        return new AwsS3PathBuilder().bucket(this.bucket).key(this.key);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AwsS3Path)) {
            return false;
        }
        AwsS3Path other = (AwsS3Path)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AwsS3Path;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public String toString() {
        return "AwsS3Path(bucket=" + this.getBucket() + ", key=" + this.getKey() + ")";
    }

    public static class AwsS3PathBuilder {
        private String bucket;
        private String key;

        AwsS3PathBuilder() {
        }

        public AwsS3PathBuilder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public AwsS3PathBuilder key(String key) {
            this.key = key;
            return this;
        }

        public AwsS3Path build() {
            return new AwsS3Path(this.bucket, this.key);
        }

        public String toString() {
            return "AwsS3Path.AwsS3PathBuilder(bucket=" + this.bucket + ", key=" + this.key + ")";
        }
    }
}

