/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class CassandraPathsModel
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="keyspaces", dependency={"host"})
    private final String keyspace;
    @PathField(prefix="tables", dependency={"keyspace"})
    private final String table;
    @PathField(prefix="views", dependency={"keyspace"})
    private final String view;
    @PathField(prefix="columns", dependency={"table", "view"})
    private final String column;

    @Override
    public String prefix() {
        return "//cassandra";
    }

    @Override
    public String name() {
        return "cassandra";
    }

    CassandraPathsModel(String host, String keyspace, String table, String view, String column) {
        this.host = host;
        this.keyspace = keyspace;
        this.table = table;
        this.view = view;
        this.column = column;
    }

    public static CassandraPathsModelBuilder builder() {
        return new CassandraPathsModelBuilder();
    }

    public CassandraPathsModelBuilder toBuilder() {
        return new CassandraPathsModelBuilder().host(this.host).keyspace(this.keyspace).table(this.table).view(this.view).column(this.column);
    }

    public String getHost() {
        return this.host;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getTable() {
        return this.table;
    }

    public String getView() {
        return this.view;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraPathsModel)) {
            return false;
        }
        CassandraPathsModel other = (CassandraPathsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$keyspace = this.getKeyspace();
        String other$keyspace = other.getKeyspace();
        if (this$keyspace == null ? other$keyspace != null : !this$keyspace.equals(other$keyspace)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$view = this.getView();
        String other$view = other.getView();
        if (this$view == null ? other$view != null : !this$view.equals(other$view)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CassandraPathsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $keyspace = this.getKeyspace();
        result = result * 59 + ($keyspace == null ? 43 : $keyspace.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }

    public String toString() {
        return "CassandraPathsModel(host=" + this.getHost() + ", keyspace=" + this.getKeyspace() + ", table=" + this.getTable() + ", view=" + this.getView() + ", column=" + this.getColumn() + ")";
    }

    public static class CassandraPathsModelBuilder {
        private String host;
        private String keyspace;
        private String table;
        private String view;
        private String column;

        CassandraPathsModelBuilder() {
        }

        public CassandraPathsModelBuilder host(String host) {
            this.host = host;
            return this;
        }

        public CassandraPathsModelBuilder keyspace(String keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public CassandraPathsModelBuilder table(String table) {
            this.table = table;
            return this;
        }

        public CassandraPathsModelBuilder view(String view) {
            this.view = view;
            return this;
        }

        public CassandraPathsModelBuilder column(String column) {
            this.column = column;
            return this;
        }

        public CassandraPathsModel build() {
            return new CassandraPathsModel(this.host, this.keyspace, this.table, this.view, this.column);
        }

        public String toString() {
            return "CassandraPathsModel.CassandraPathsModelBuilder(host=" + this.host + ", keyspace=" + this.keyspace + ", table=" + this.table + ", view=" + this.view + ", column=" + this.column + ")";
        }
    }
}

