/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class CouchbasePathsModel
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="buckets", dependency={"host"})
    private final String bucket;
    @PathField(prefix="scopes", dependency={"bucket"})
    private final String scope;
    @PathField(prefix="collections", dependency={"scope"})
    private final String collection;
    @PathField(prefix="columns", dependency={"collection"})
    private final String column;

    @Override
    public String prefix() {
        return "//couchbase";
    }

    @Override
    public String name() {
        return "couchbase";
    }

    CouchbasePathsModel(String host, String bucket, String scope, String collection, String column) {
        this.host = host;
        this.bucket = bucket;
        this.scope = scope;
        this.collection = collection;
        this.column = column;
    }

    public static CouchbasePathsModelBuilder builder() {
        return new CouchbasePathsModelBuilder();
    }

    public CouchbasePathsModelBuilder toBuilder() {
        return new CouchbasePathsModelBuilder().host(this.host).bucket(this.bucket).scope(this.scope).collection(this.collection).column(this.column);
    }

    public String getHost() {
        return this.host;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getScope() {
        return this.scope;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CouchbasePathsModel)) {
            return false;
        }
        CouchbasePathsModel other = (CouchbasePathsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CouchbasePathsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }

    public String toString() {
        return "CouchbasePathsModel(host=" + this.getHost() + ", bucket=" + this.getBucket() + ", scope=" + this.getScope() + ", collection=" + this.getCollection() + ", column=" + this.getColumn() + ")";
    }

    public static class CouchbasePathsModelBuilder {
        private String host;
        private String bucket;
        private String scope;
        private String collection;
        private String column;

        CouchbasePathsModelBuilder() {
        }

        public CouchbasePathsModelBuilder host(String host) {
            this.host = host;
            return this;
        }

        public CouchbasePathsModelBuilder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public CouchbasePathsModelBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public CouchbasePathsModelBuilder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public CouchbasePathsModelBuilder column(String column) {
            this.column = column;
            return this;
        }

        public CouchbasePathsModel build() {
            return new CouchbasePathsModel(this.host, this.bucket, this.scope, this.collection, this.column);
        }

        public String toString() {
            return "CouchbasePathsModel.CouchbasePathsModelBuilder(host=" + this.host + ", bucket=" + this.bucket + ", scope=" + this.scope + ", collection=" + this.collection + ", column=" + this.column + ")";
        }
    }
}

