/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class KafkaConnectorPath
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="connectors", dependency={"host"})
    private final String connector;

    @Override
    public String prefix() {
        return "//kafkaconnect";
    }

    @Override
    public String name() {
        return "kafka_connect";
    }

    KafkaConnectorPath(String host, String connector) {
        this.host = host;
        this.connector = connector;
    }

    public static KafkaConnectorPathBuilder builder() {
        return new KafkaConnectorPathBuilder();
    }

    public KafkaConnectorPathBuilder toBuilder() {
        return new KafkaConnectorPathBuilder().host(this.host).connector(this.connector);
    }

    public String getHost() {
        return this.host;
    }

    public String getConnector() {
        return this.connector;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConnectorPath)) {
            return false;
        }
        KafkaConnectorPath other = (KafkaConnectorPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$connector = this.getConnector();
        String other$connector = other.getConnector();
        return !(this$connector == null ? other$connector != null : !this$connector.equals(other$connector));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaConnectorPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $connector = this.getConnector();
        result = result * 59 + ($connector == null ? 43 : $connector.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaConnectorPath(host=" + this.getHost() + ", connector=" + this.getConnector() + ")";
    }

    public static class KafkaConnectorPathBuilder {
        private String host;
        private String connector;

        KafkaConnectorPathBuilder() {
        }

        public KafkaConnectorPathBuilder host(String host) {
            this.host = host;
            return this;
        }

        public KafkaConnectorPathBuilder connector(String connector) {
            this.connector = connector;
            return this;
        }

        public KafkaConnectorPath build() {
            return new KafkaConnectorPath(this.host, this.connector);
        }

        public String toString() {
            return "KafkaConnectorPath.KafkaConnectorPathBuilder(host=" + this.host + ", connector=" + this.connector + ")";
        }
    }
}

