/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class KafkaPath
implements OddrnPath {
    @PathField
    private final String cluster;
    @PathField(prefix="topics", dependency={"cluster"})
    private final String topic;
    @PathField(prefix="columns", dependency={"topic"})
    private final String column;

    @Override
    public String prefix() {
        return "//kafka";
    }

    @Override
    public String name() {
        return "kafka";
    }

    KafkaPath(String cluster, String topic, String column) {
        this.cluster = cluster;
        this.topic = topic;
        this.column = column;
    }

    public static KafkaPathBuilder builder() {
        return new KafkaPathBuilder();
    }

    public KafkaPathBuilder toBuilder() {
        return new KafkaPathBuilder().cluster(this.cluster).topic(this.topic).column(this.column);
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaPath)) {
            return false;
        }
        KafkaPath other = (KafkaPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cluster = this.getCluster();
        String other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaPath(cluster=" + this.getCluster() + ", topic=" + this.getTopic() + ", column=" + this.getColumn() + ")";
    }

    public static class KafkaPathBuilder {
        private String cluster;
        private String topic;
        private String column;

        KafkaPathBuilder() {
        }

        public KafkaPathBuilder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public KafkaPathBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public KafkaPathBuilder column(String column) {
            this.column = column;
            return this;
        }

        public KafkaPath build() {
            return new KafkaPath(this.cluster, this.topic, this.column);
        }

        public String toString() {
            return "KafkaPath.KafkaPathBuilder(cluster=" + this.cluster + ", topic=" + this.topic + ", column=" + this.column + ")";
        }
    }
}

