/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class MongoPathsModel
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="databases", dependency={"host"})
    private final String database;
    @PathField(prefix="collections", dependency={"database"})
    private final String collection;
    @PathField(prefix="columns", dependency={"collection"})
    private final String column;

    @Override
    public String prefix() {
        return "//mongo";
    }

    @Override
    public String name() {
        return "mongo";
    }

    MongoPathsModel(String host, String database, String collection, String column) {
        this.host = host;
        this.database = database;
        this.collection = collection;
        this.column = column;
    }

    public static MongoPathsModelBuilder builder() {
        return new MongoPathsModelBuilder();
    }

    public MongoPathsModelBuilder toBuilder() {
        return new MongoPathsModelBuilder().host(this.host).database(this.database).collection(this.collection).column(this.column);
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoPathsModel)) {
            return false;
        }
        MongoPathsModel other = (MongoPathsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MongoPathsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }

    public String toString() {
        return "MongoPathsModel(host=" + this.getHost() + ", database=" + this.getDatabase() + ", collection=" + this.getCollection() + ", column=" + this.getColumn() + ")";
    }

    public static class MongoPathsModelBuilder {
        private String host;
        private String database;
        private String collection;
        private String column;

        MongoPathsModelBuilder() {
        }

        public MongoPathsModelBuilder host(String host) {
            this.host = host;
            return this;
        }

        public MongoPathsModelBuilder database(String database) {
            this.database = database;
            return this;
        }

        public MongoPathsModelBuilder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public MongoPathsModelBuilder column(String column) {
            this.column = column;
            return this;
        }

        public MongoPathsModel build() {
            return new MongoPathsModel(this.host, this.database, this.collection, this.column);
        }

        public String toString() {
            return "MongoPathsModel.MongoPathsModelBuilder(host=" + this.host + ", database=" + this.database + ", collection=" + this.collection + ", column=" + this.column + ")";
        }
    }
}

