/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class Neo4jPathsModel
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="databases", dependency={"host"})
    private final String database;
    @PathField(prefix="nodes", dependency={"database"})
    private final String node;
    @PathField(prefix="fields", dependency={"node"})
    private final String field;

    @Override
    public String prefix() {
        return "//neo4j";
    }

    @Override
    public String name() {
        return "neo4j";
    }

    Neo4jPathsModel(String host, String database, String node, String field) {
        this.host = host;
        this.database = database;
        this.node = node;
        this.field = field;
    }

    public static Neo4jPathsModelBuilder builder() {
        return new Neo4jPathsModelBuilder();
    }

    public Neo4jPathsModelBuilder toBuilder() {
        return new Neo4jPathsModelBuilder().host(this.host).database(this.database).node(this.node).field(this.field);
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getNode() {
        return this.node;
    }

    public String getField() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Neo4jPathsModel)) {
            return false;
        }
        Neo4jPathsModel other = (Neo4jPathsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$node = this.getNode();
        String other$node = other.getNode();
        if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        return !(this$field == null ? other$field != null : !this$field.equals(other$field));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Neo4jPathsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : $node.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        return result;
    }

    public String toString() {
        return "Neo4jPathsModel(host=" + this.getHost() + ", database=" + this.getDatabase() + ", node=" + this.getNode() + ", field=" + this.getField() + ")";
    }

    public static class Neo4jPathsModelBuilder {
        private String host;
        private String database;
        private String node;
        private String field;

        Neo4jPathsModelBuilder() {
        }

        public Neo4jPathsModelBuilder host(String host) {
            this.host = host;
            return this;
        }

        public Neo4jPathsModelBuilder database(String database) {
            this.database = database;
            return this;
        }

        public Neo4jPathsModelBuilder node(String node) {
            this.node = node;
            return this;
        }

        public Neo4jPathsModelBuilder field(String field) {
            this.field = field;
            return this;
        }

        public Neo4jPathsModel build() {
            return new Neo4jPathsModel(this.host, this.database, this.node, this.field);
        }

        public String toString() {
            return "Neo4jPathsModel.Neo4jPathsModelBuilder(host=" + this.host + ", database=" + this.database + ", node=" + this.node + ", field=" + this.field + ")";
        }
    }
}

