/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class PrestoPath
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="catalogs", dependency={"host"})
    private final String catalog;
    @PathField(prefix="schemas", dependency={"catalog"})
    private final String schema;
    @PathField(prefix="tables", dependency={"schema"})
    private final String table;
    @PathField(prefix="columns", dependency={"table"})
    private final String column;

    @Override
    public String prefix() {
        return "//presto";
    }

    @Override
    public String name() {
        return "presto";
    }

    PrestoPath(String host, String catalog, String schema, String table, String column) {
        this.host = host;
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
        this.column = column;
    }

    public static PrestoPathBuilder builder() {
        return new PrestoPathBuilder();
    }

    public PrestoPathBuilder toBuilder() {
        return new PrestoPathBuilder().host(this.host).catalog(this.catalog).schema(this.schema).table(this.table).column(this.column);
    }

    public String getHost() {
        return this.host;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrestoPath)) {
            return false;
        }
        PrestoPath other = (PrestoPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$catalog = this.getCatalog();
        String other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrestoPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }

    public String toString() {
        return "PrestoPath(host=" + this.getHost() + ", catalog=" + this.getCatalog() + ", schema=" + this.getSchema() + ", table=" + this.getTable() + ", column=" + this.getColumn() + ")";
    }

    public static class PrestoPathBuilder {
        private String host;
        private String catalog;
        private String schema;
        private String table;
        private String column;

        PrestoPathBuilder() {
        }

        public PrestoPathBuilder host(String host) {
            this.host = host;
            return this;
        }

        public PrestoPathBuilder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public PrestoPathBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public PrestoPathBuilder table(String table) {
            this.table = table;
            return this;
        }

        public PrestoPathBuilder column(String column) {
            this.column = column;
            return this;
        }

        public PrestoPath build() {
            return new PrestoPath(this.host, this.catalog, this.schema, this.table, this.column);
        }

        public String toString() {
            return "PrestoPath.PrestoPathBuilder(host=" + this.host + ", catalog=" + this.catalog + ", schema=" + this.schema + ", table=" + this.table + ", column=" + this.column + ")";
        }
    }
}

