/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class SnowflakePath
implements OddrnPath {
    @PathField
    private final String account;
    @PathField(prefix="databases", dependency={"account"})
    private final String database;
    @PathField(prefix="schemas", dependency={"database"})
    private final String schema;
    @PathField(prefix="tables", dependency={"schema"})
    private final String table;
    @PathField(prefix="views", dependency={"schema"})
    private final String view;
    @PathField(prefix="columns", dependency={"table", "view"})
    private final String column;
    @PathField(prefix="owners", dependency={"database"})
    private final String owner;

    @Override
    public String prefix() {
        return "//snowflake";
    }

    @Override
    public String name() {
        return "snowflake";
    }

    SnowflakePath(String account, String database, String schema, String table, String view, String column, String owner) {
        this.account = account;
        this.database = database;
        this.schema = schema;
        this.table = table;
        this.view = view;
        this.column = column;
        this.owner = owner;
    }

    public static SnowflakePathBuilder builder() {
        return new SnowflakePathBuilder();
    }

    public SnowflakePathBuilder toBuilder() {
        return new SnowflakePathBuilder().account(this.account).database(this.database).schema(this.schema).table(this.table).view(this.view).column(this.column).owner(this.owner);
    }

    public String getAccount() {
        return this.account;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getView() {
        return this.view;
    }

    public String getColumn() {
        return this.column;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnowflakePath)) {
            return false;
        }
        SnowflakePath other = (SnowflakePath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$view = this.getView();
        String other$view = other.getView();
        if (this$view == null ? other$view != null : !this$view.equals(other$view)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SnowflakePath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }

    public String toString() {
        return "SnowflakePath(account=" + this.getAccount() + ", database=" + this.getDatabase() + ", schema=" + this.getSchema() + ", table=" + this.getTable() + ", view=" + this.getView() + ", column=" + this.getColumn() + ", owner=" + this.getOwner() + ")";
    }

    public static class SnowflakePathBuilder {
        private String account;
        private String database;
        private String schema;
        private String table;
        private String view;
        private String column;
        private String owner;

        SnowflakePathBuilder() {
        }

        public SnowflakePathBuilder account(String account) {
            this.account = account;
            return this;
        }

        public SnowflakePathBuilder database(String database) {
            this.database = database;
            return this;
        }

        public SnowflakePathBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public SnowflakePathBuilder table(String table) {
            this.table = table;
            return this;
        }

        public SnowflakePathBuilder view(String view) {
            this.view = view;
            return this;
        }

        public SnowflakePathBuilder column(String column) {
            this.column = column;
            return this;
        }

        public SnowflakePathBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public SnowflakePath build() {
            return new SnowflakePath(this.account, this.database, this.schema, this.table, this.view, this.column, this.owner);
        }

        public String toString() {
            return "SnowflakePath.SnowflakePathBuilder(account=" + this.account + ", database=" + this.database + ", schema=" + this.schema + ", table=" + this.table + ", view=" + this.view + ", column=" + this.column + ", owner=" + this.owner + ")";
        }
    }
}

