/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class SupersetPathsModel
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="databases", dependency={"host"})
    private final String database;
    @PathField(prefix="datasets", dependency={"database"})
    private final String dataset;
    @PathField(prefix="columns", dependency={"dataset"})
    private final String column;
    @PathField(prefix="dashboards", dependency={"host"})
    private final String dashboard;

    @Override
    public String prefix() {
        return "//superset";
    }

    @Override
    public String name() {
        return "superset";
    }

    SupersetPathsModel(String host, String database, String dataset, String column, String dashboard) {
        this.host = host;
        this.database = database;
        this.dataset = dataset;
        this.column = column;
        this.dashboard = dashboard;
    }

    public static SupersetPathsModelBuilder builder() {
        return new SupersetPathsModelBuilder();
    }

    public SupersetPathsModelBuilder toBuilder() {
        return new SupersetPathsModelBuilder().host(this.host).database(this.database).dataset(this.dataset).column(this.column).dashboard(this.dashboard);
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getColumn() {
        return this.column;
    }

    public String getDashboard() {
        return this.dashboard;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SupersetPathsModel)) {
            return false;
        }
        SupersetPathsModel other = (SupersetPathsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$dataset = this.getDataset();
        String other$dataset = other.getDataset();
        if (this$dataset == null ? other$dataset != null : !this$dataset.equals(other$dataset)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        String this$dashboard = this.getDashboard();
        String other$dashboard = other.getDashboard();
        return !(this$dashboard == null ? other$dashboard != null : !this$dashboard.equals(other$dashboard));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SupersetPathsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $dataset = this.getDataset();
        result = result * 59 + ($dataset == null ? 43 : $dataset.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        String $dashboard = this.getDashboard();
        result = result * 59 + ($dashboard == null ? 43 : $dashboard.hashCode());
        return result;
    }

    public String toString() {
        return "SupersetPathsModel(host=" + this.getHost() + ", database=" + this.getDatabase() + ", dataset=" + this.getDataset() + ", column=" + this.getColumn() + ", dashboard=" + this.getDashboard() + ")";
    }

    public static class SupersetPathsModelBuilder {
        private String host;
        private String database;
        private String dataset;
        private String column;
        private String dashboard;

        SupersetPathsModelBuilder() {
        }

        public SupersetPathsModelBuilder host(String host) {
            this.host = host;
            return this;
        }

        public SupersetPathsModelBuilder database(String database) {
            this.database = database;
            return this;
        }

        public SupersetPathsModelBuilder dataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public SupersetPathsModelBuilder column(String column) {
            this.column = column;
            return this;
        }

        public SupersetPathsModelBuilder dashboard(String dashboard) {
            this.dashboard = dashboard;
            return this;
        }

        public SupersetPathsModel build() {
            return new SupersetPathsModel(this.host, this.database, this.dataset, this.column, this.dashboard);
        }

        public String toString() {
            return "SupersetPathsModel.SupersetPathsModelBuilder(host=" + this.host + ", database=" + this.database + ", dataset=" + this.dataset + ", column=" + this.column + ", dashboard=" + this.dashboard + ")";
        }
    }
}

