/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class TarantoolPathsModel
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="spaces", dependency={"host"})
    private final String space;
    @PathField(prefix="columns", dependency={"space"})
    private final String column;

    @Override
    public String prefix() {
        return "//tarantool";
    }

    @Override
    public String name() {
        return "tarantool";
    }

    TarantoolPathsModel(String host, String space, String column) {
        this.host = host;
        this.space = space;
        this.column = column;
    }

    public static TarantoolPathsModelBuilder builder() {
        return new TarantoolPathsModelBuilder();
    }

    public TarantoolPathsModelBuilder toBuilder() {
        return new TarantoolPathsModelBuilder().host(this.host).space(this.space).column(this.column);
    }

    public String getHost() {
        return this.host;
    }

    public String getSpace() {
        return this.space;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TarantoolPathsModel)) {
            return false;
        }
        TarantoolPathsModel other = (TarantoolPathsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$space = this.getSpace();
        String other$space = other.getSpace();
        if (this$space == null ? other$space != null : !this$space.equals(other$space)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TarantoolPathsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $space = this.getSpace();
        result = result * 59 + ($space == null ? 43 : $space.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }

    public String toString() {
        return "TarantoolPathsModel(host=" + this.getHost() + ", space=" + this.getSpace() + ", column=" + this.getColumn() + ")";
    }

    public static class TarantoolPathsModelBuilder {
        private String host;
        private String space;
        private String column;

        TarantoolPathsModelBuilder() {
        }

        public TarantoolPathsModelBuilder host(String host) {
            this.host = host;
            return this;
        }

        public TarantoolPathsModelBuilder space(String space) {
            this.space = space;
            return this;
        }

        public TarantoolPathsModelBuilder column(String column) {
            this.column = column;
            return this;
        }

        public TarantoolPathsModel build() {
            return new TarantoolPathsModel(this.host, this.space, this.column);
        }

        public String toString() {
            return "TarantoolPathsModel.TarantoolPathsModelBuilder(host=" + this.host + ", space=" + this.space + ", column=" + this.column + ")";
        }
    }
}

