/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IDag;
import org.javarosa.core.model.QuickTriggerable;
import org.javarosa.core.model.condition.Condition;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;

public class April2014DagImpl
extends IDag {
    private final FormDef.EvalBehavior mode = FormDef.EvalBehavior.April_2014;

    public April2014DagImpl(IDag.EventNotifierAccessor accessor) {
        super(accessor);
    }

    @Override
    public FormDef.EvalBehavior getEvalBehavior() {
        return this.mode;
    }

    @Override
    public QuickTriggerable getTriggerableForRepeatGroup(TreeReference repeatRef) {
        return (QuickTriggerable)this.conditionRepeatTargetIndex.get(repeatRef.genericize());
    }

    @Override
    public void deleteRepeatGroup(FormInstance mainInstance, EvaluationContext evalContext, TreeReference deleteRef, TreeElement parentElement, TreeElement deletedElement) {
        this.triggerTriggerables(mainInstance, evalContext, deleteRef, true);
    }

    @Override
    public void createRepeatGroup(FormInstance mainInstance, EvaluationContext evalContext, TreeReference createRef, TreeElement parentElement, TreeElement createdElement) {
        this.triggerTriggerables(mainInstance, evalContext, createRef, true);
        this.initializeTriggerables(mainInstance, evalContext, createRef, true);
    }

    @Override
    public void copyItemsetAnswer(FormInstance mainInstance, EvaluationContext evalContext, TreeReference copyRef, TreeElement copyToElement, boolean midSurvey) {
        this.triggerTriggerables(mainInstance, evalContext, copyRef, midSurvey);
        this.initializeTriggerables(mainInstance, evalContext, copyRef, midSurvey);
    }

    @Override
    public void finalizeTriggerables(FormInstance mainInstance, EvaluationContext evalContext) throws IllegalStateException {
        this.triggerablesDAG.clear();
        ArrayList<QuickTriggerable[]> partialOrdering = new ArrayList<QuickTriggerable[]>();
        for (int i = 0; i < this.unorderedTriggerables.size(); ++i) {
            QuickTriggerable qt = (QuickTriggerable)this.unorderedTriggerables.get(i);
            ArrayList<QuickTriggerable> deps = new ArrayList<QuickTriggerable>();
            this.fillTriggeredElements(evalContext, qt, deps);
            for (int j = 0; j < deps.size(); ++j) {
                QuickTriggerable qu = deps.get(j);
                QuickTriggerable[] edge = new QuickTriggerable[]{qt, qu};
                partialOrdering.add(edge);
            }
        }
        ArrayList vertices = new ArrayList(this.unorderedTriggerables);
        ArrayList roots = new ArrayList(this.unorderedTriggerables.size());
        while (vertices.size() > 0) {
            QuickTriggerable[] edge;
            int i;
            roots.clear();
            roots.addAll(vertices);
            for (i = 0; i < partialOrdering.size(); ++i) {
                edge = (QuickTriggerable[])partialOrdering.get(i);
                roots.remove(edge[1]);
            }
            if (roots.size() == 0) {
                String hints = "";
                for (QuickTriggerable qt : vertices) {
                    for (TreeReference r : qt.t.getTargets()) {
                        hints = hints + "\n" + r.toString(true);
                    }
                }
                String message = "Cycle detected in form's relevant and calculation logic!";
                if (!hints.equals("")) {
                    message = message + "\nThe following nodes are likely involved in the loop:" + hints;
                }
                throw new IllegalStateException(message);
            }
            for (i = 0; i < roots.size(); ++i) {
                QuickTriggerable root = (QuickTriggerable)roots.get(i);
                this.triggerablesDAG.add(root);
                vertices.remove(root);
            }
            for (i = partialOrdering.size() - 1; i >= 0; --i) {
                edge = (QuickTriggerable[])partialOrdering.get(i);
                if (!roots.contains(edge[0])) continue;
                partialOrdering.remove(i);
            }
        }
        this.conditionRepeatTargetIndex.clear();
        for (QuickTriggerable qt : this.triggerablesDAG) {
            if (!(qt.t instanceof Condition)) continue;
            List<TreeReference> targets = qt.t.getTargets();
            for (TreeReference target : targets) {
                if (mainInstance.getTemplate(target) == null) continue;
                this.conditionRepeatTargetIndex.put(target, qt);
            }
        }
    }

    private void fillTriggeredElements(EvaluationContext evalContext, QuickTriggerable qt, ArrayList<QuickTriggerable> destination) {
        if (qt.t.canCascade()) {
            for (int j = 0; j < qt.t.getTargets().size(); ++j) {
                TreeReference target = qt.t.getTargets().get(j);
                ArrayList<TreeReference> updatedNodes = new ArrayList<TreeReference>();
                updatedNodes.add(target);
                if (qt.t.isCascadingToChildren()) {
                    this.addChildrenOfReference(evalContext, target, updatedNodes);
                }
                for (TreeReference ref : updatedNodes) {
                    ArrayList triggered = (ArrayList)this.triggerIndex.get(ref.hasPredicates() ? ref.removePredicates() : ref);
                    if (triggered == null) continue;
                    for (int k = 0; k < triggered.size(); ++k) {
                        QuickTriggerable qu = (QuickTriggerable)triggered.get(k);
                        if (destination.contains(qu)) continue;
                        destination.add(qu);
                    }
                }
            }
        }
    }

    private void addChildrenOfReference(EvaluationContext evalContext, TreeReference original, ArrayList<TreeReference> toAdd) {
        for (TreeReference ref : evalContext.expandReference(original)) {
            this.addChildrenOfElement(evalContext.resolveReference(ref), toAdd);
        }
    }

    private void addChildrenOfElement(AbstractTreeElement el, ArrayList<TreeReference> toAdd) {
        for (int i = 0; i < el.getNumChildren(); ++i) {
            Object child = el.getChildAt(i);
            toAdd.add(child.getRef().genericize());
            this.addChildrenOfElement((AbstractTreeElement)child, toAdd);
        }
    }

    @Override
    public Collection<QuickTriggerable> initializeTriggerables(FormInstance mainInstance, EvaluationContext evalContext, TreeReference rootRef, boolean midSurvey) {
        TreeReference genericRoot = rootRef.genericize();
        ArrayList<QuickTriggerable> applicable = new ArrayList<QuickTriggerable>();
        block0: for (int i = 0; i < this.triggerablesDAG.size(); ++i) {
            QuickTriggerable qt = (QuickTriggerable)this.triggerablesDAG.get(i);
            for (int j = 0; j < qt.t.getTargets().size(); ++j) {
                TreeReference target = qt.t.getTargets().get(j);
                if (!genericRoot.isParentOf(target, false)) continue;
                applicable.add(qt);
                continue block0;
            }
        }
        return this.evaluateTriggerables(mainInstance, evalContext, applicable, rootRef);
    }

    @Override
    public Collection<QuickTriggerable> triggerTriggerables(FormInstance mainInstance, EvaluationContext evalContext, TreeReference ref, boolean midSurvey) {
        TreeReference genericRef = ref.genericize();
        ArrayList triggered = (ArrayList)this.triggerIndex.get(genericRef);
        if (triggered == null) {
            return Collections.emptySet();
        }
        ArrayList<QuickTriggerable> triggeredCopy = new ArrayList<QuickTriggerable>(triggered);
        return this.evaluateTriggerables(mainInstance, evalContext, triggeredCopy, ref);
    }

    private Collection<QuickTriggerable> evaluateTriggerables(FormInstance mainInstance, EvaluationContext evalContext, ArrayList<QuickTriggerable> tv, TreeReference anchorRef) {
        QuickTriggerable qt;
        int i;
        for (i = 0; i < tv.size(); ++i) {
            qt = tv.get(i);
            this.fillTriggeredElements(evalContext, qt, tv);
        }
        for (i = 0; i < this.triggerablesDAG.size(); ++i) {
            qt = (QuickTriggerable)this.triggerablesDAG.get(i);
            if (!tv.contains(qt)) continue;
            this.evaluateTriggerable(mainInstance, evalContext, qt, anchorRef);
        }
        return tv;
    }

    private void evaluateTriggerable(FormInstance mainInstance, EvaluationContext evalContext, QuickTriggerable qt, TreeReference anchorRef) {
        TreeReference contextRef = qt.t.contextualizeContextRef(anchorRef);
        try {
            List<TreeReference> v = evalContext.expandReference(contextRef);
            for (int i = 0; i < v.size(); ++i) {
                EvaluationContext ec = new EvaluationContext(evalContext, v.get(i));
                qt.t.apply(mainInstance, ec, v.get(i));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error evaluating field '" + contextRef.getNameLast() + "': " + e.getMessage(), e);
        }
    }

    @Override
    public boolean shouldTrustPreviouslyCommittedAnswer() {
        return false;
    }
}

