/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

import java.util.Date;
import org.javarosa.core.model.DataType;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.condition.Triggerable;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.GeoPointData;
import org.javarosa.core.model.data.GeoShapeData;
import org.javarosa.core.model.data.GeoTraceData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.LongData;
import org.javarosa.core.model.data.MultipleItemsData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.TimeData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;

public class Recalculate
extends Triggerable {
    public Recalculate() {
    }

    public Recalculate(IConditionExpr expr, TreeReference contextRef) {
        super(expr, contextRef);
    }

    @Override
    public Object eval(FormInstance model, EvaluationContext ec) {
        return this.evalRaw(model, ec);
    }

    @Override
    public void apply(TreeReference ref, Object result, FormInstance mainInstance) {
        TreeElement element = (TreeElement)mainInstance.resolveReference(ref);
        int dataType = element.getDataType();
        element.setAnswer(Recalculate.wrapData(result, dataType));
    }

    @Override
    public boolean canCascade() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Recalculate) {
            Recalculate r = (Recalculate)o;
            return this == r || super.equals(r);
        }
        return false;
    }

    public static IAnswerData wrapData(Object val, int intDataType) {
        if (val instanceof String && ((String)val).length() == 0 || val instanceof Double && ((Double)val).isNaN()) {
            return null;
        }
        DataType dataType = DataType.from(intDataType);
        if (DataType.BOOLEAN == dataType || val instanceof Boolean) {
            boolean b;
            if (val instanceof Boolean) {
                b = (Boolean)val;
            } else if (val instanceof Double) {
                Double d = (Double)val;
                b = Math.abs(d) > 1.0E-12 && !Double.isNaN(d);
            } else if (val instanceof String) {
                String s = (String)val;
                b = s.length() > 0;
            } else {
                throw new RuntimeException("unrecognized data representation while trying to convert to BOOLEAN");
            }
            return new BooleanData(b);
        }
        if (val instanceof Double) {
            long l;
            boolean isIntegral;
            double d = (Double)val;
            boolean bl = isIntegral = Math.abs(d - (double)(l = (long)d)) < 1.0E-9;
            if (DataType.INTEGER == dataType || isIntegral && Integer.MAX_VALUE >= l && Integer.MIN_VALUE <= l) {
                return new IntegerData((int)d);
            }
            if (DataType.LONG == dataType || isIntegral) {
                return new LongData((long)d);
            }
            return new DecimalData(d);
        }
        if (dataType == DataType.GEOPOINT) {
            return new GeoPointData().cast(new UncastData(String.valueOf(val)));
        }
        if (dataType == DataType.GEOSHAPE) {
            return new GeoShapeData().cast(new UncastData(String.valueOf(val)));
        }
        if (dataType == DataType.GEOTRACE) {
            return new GeoTraceData().cast(new UncastData(String.valueOf(val)));
        }
        if (dataType == DataType.CHOICE) {
            return new SelectOneData().cast(new UncastData(String.valueOf(val)));
        }
        if (dataType == DataType.MULTIPLE_ITEMS) {
            return new MultipleItemsData().cast(new UncastData(String.valueOf(val)));
        }
        if (val instanceof String) {
            return new StringData((String)val);
        }
        if (val instanceof Date) {
            if (dataType == DataType.TIME) {
                return new TimeData((Date)val);
            }
            if (dataType == DataType.DATE) {
                return new DateData((Date)val);
            }
            return new DateTimeData((Date)val);
        }
        throw new RuntimeException("unrecognized data type in 'calculate' expression: " + val.getClass().getName());
    }
}

