/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.CsvExternalInstance;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.InstanceInitializationFactory;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.XmlExternalInstance;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.reference.ReferenceManager;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xml.util.InvalidStructureException;
import org.javarosa.xml.util.UnfullfilledRequirementsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class ExternalDataInstance
extends DataInstance {
    private static final Logger logger = LoggerFactory.getLogger((String)ExternalDataInstance.class.getSimpleName());
    private String path;
    private TreeElement root;

    public ExternalDataInstance() {
    }

    private ExternalDataInstance(TreeElement root, String instanceId, String path) {
        super(instanceId);
        this.path = path;
        this.setName(instanceId);
        this.setRoot(root);
    }

    public static ExternalDataInstance build(String instanceSrc, String instanceId) throws IOException, UnfullfilledRequirementsException, XmlPullParserException, InvalidStructureException, InvalidReferenceException {
        TreeElement root = ExternalDataInstance.parseExternalInstance(instanceSrc, instanceId);
        return new ExternalDataInstance(root, instanceId, instanceSrc);
    }

    private static TreeElement parseExternalInstance(String instanceSrc, String instanceId) throws IOException, InvalidReferenceException, InvalidStructureException, XmlPullParserException, UnfullfilledRequirementsException {
        String path = ExternalDataInstance.getPath(instanceSrc);
        return instanceSrc.contains("file-csv") ? CsvExternalInstance.parse(instanceId, path) : XmlExternalInstance.parse(instanceId, path);
    }

    public AbstractTreeElement getBase() {
        return this.root;
    }

    public AbstractTreeElement getRoot() {
        if (this.root.getNumChildren() == 0) {
            throw new RuntimeException("root node has no children");
        }
        return this.root.getChildAt(0);
    }

    private void setRoot(TreeElement topLevel) {
        this.root = new TreeElement();
        this.root.setInstanceName(this.getName());
        this.root.addChild(topLevel);
    }

    @Override
    public void initialize(InstanceInitializationFactory initializer, String instanceId) {
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        super.readExternal(in, pf);
        this.path = ExtUtil.readString(in);
        try {
            this.setRoot(ExternalDataInstance.parseExternalInstance(this.path, this.getInstanceId()));
        }
        catch (InvalidReferenceException | InvalidStructureException | UnfullfilledRequirementsException | XmlPullParserException e) {
            throw new DeserializationException("Unable to parse external instance: " + e);
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        super.writeExternal(out);
        ExtUtil.write(out, this.path);
    }

    private static String getPath(String srcLocation) throws InvalidReferenceException {
        String uri = ReferenceManager.instance().deriveReference(srcLocation).getLocalURI();
        return uri.startsWith("//") ? uri.substring(1) : uri;
    }
}

