/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.model.instance.TreeReferenceLevel;
import org.javarosa.core.util.DataUtil;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.XPathException;
import org.javarosa.xpath.expr.XPathExpression;

public class TreeReference
implements Externalizable,
Serializable {
    @Deprecated
    public static final int DEFAULT_MUTLIPLICITY = 0;
    public static final int DEFAULT_MULTIPLICITY = 0;
    public static final int INDEX_UNBOUND = -1;
    public static final int INDEX_TEMPLATE = -2;
    public static final int INDEX_ATTRIBUTE = -4;
    public static final int INDEX_REPEAT_JUNCTURE = -10;
    public static final int CONTEXT_ABSOLUTE = 0;
    public static final int CONTEXT_INHERITED = 1;
    public static final int CONTEXT_ORIGINAL = 2;
    public static final int CONTEXT_INSTANCE = 4;
    public static final int REF_ABSOLUTE = -1;
    public static final String NAME_WILDCARD = "*";
    private int refLevel = 0;
    private int contextType = 0;
    private String instanceName = null;
    private List<TreeReferenceLevel> data = new ArrayList<TreeReferenceLevel>(0);

    public static TreeReference rootRef() {
        TreeReference root = new TreeReference();
        root.refLevel = -1;
        root.contextType = 0;
        return root;
    }

    public static TreeReference selfRef() {
        TreeReference self = new TreeReference();
        self.refLevel = 0;
        self.contextType = 1;
        return self;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public int getMultiplicity(int index) {
        return this.data.get(index).getMultiplicity();
    }

    public String getName(int index) {
        return this.data.get(index).getName();
    }

    public int getMultLast() {
        return this.data.get(this.data.size() - 1).getMultiplicity();
    }

    public String getNameLast() {
        return this.data.get(this.data.size() - 1).getName();
    }

    public void setMultiplicity(int i, int mult) {
        this.data.set(i, this.data.get(i).setMultiplicity(mult));
    }

    public int size() {
        return this.data.size();
    }

    private void add(TreeReferenceLevel level) {
        this.data.add(level);
    }

    public void add(String name, int mult) {
        this.add(new TreeReferenceLevel(name, mult).intern());
    }

    public void addPredicate(int key, List<XPathExpression> xpe) {
        this.data.set(key, this.data.get(key).setPredicates(xpe));
    }

    public List<XPathExpression> getPredicate(int key) {
        return this.data.get(key).getPredicates();
    }

    public int getRefLevel() {
        return this.refLevel;
    }

    public void setRefLevel(int refLevel) {
        this.refLevel = refLevel;
    }

    public void incrementRefLevel() {
        if (!this.isAbsolute()) {
            ++this.refLevel;
        }
    }

    public boolean isAbsolute() {
        return this.refLevel == -1;
    }

    public boolean isAmbiguous() {
        for (int i = 1; i < this.size(); ++i) {
            if (this.getMultiplicity(i) != -1) continue;
            return true;
        }
        return false;
    }

    public TreeReference clone() {
        TreeReference newRef = new TreeReference();
        newRef.setRefLevel(this.refLevel);
        for (TreeReferenceLevel l : this.data) {
            newRef.add(l.shallowCopy());
        }
        newRef.setInstanceName(this.instanceName);
        newRef.setContext(this.contextType);
        return newRef;
    }

    public boolean removeLastLevel() {
        int size = this.size();
        if (size == 0) {
            if (this.isAbsolute()) {
                return false;
            }
            ++this.refLevel;
            return true;
        }
        this.data.remove(size - 1);
        return true;
    }

    public TreeReference getParentRef() {
        TreeReference ref = this.clone();
        if (ref.removeLastLevel()) {
            return ref;
        }
        return null;
    }

    public TreeReference parent(TreeReference baseReference) {
        if (this.isAbsolute()) {
            return this.clone();
        }
        TreeReference newRef = baseReference.clone();
        if (this.refLevel > 0) {
            if (!baseReference.isAbsolute() && baseReference.size() == 0) {
                newRef.refLevel += this.refLevel;
            } else {
                return null;
            }
        }
        for (TreeReferenceLevel level : this.data) {
            newRef.add(level.shallowCopy());
        }
        return newRef;
    }

    public TreeReference anchor(TreeReference baseReference) throws XPathException {
        if (this.isAbsolute()) {
            return this.clone();
        }
        if (!baseReference.isAbsolute()) {
            throw new XPathException(baseReference.toString(true) + " is not an absolute reference");
        }
        if (this.refLevel > baseReference.size()) {
            throw new XPathException("Attempt to parent past the root node " + this.toString(true));
        }
        TreeReference newRef = baseReference.clone();
        for (int i = 0; i < this.refLevel; ++i) {
            newRef.removeLastLevel();
        }
        for (TreeReferenceLevel level : this.data) {
            newRef.add(level.shallowCopy());
        }
        return newRef;
    }

    public TreeReference contextualize(TreeReference contextRef) {
        if (!contextRef.isAbsolute()) {
            return null;
        }
        TreeReference newRef = this.anchor(contextRef);
        newRef.setContext(contextRef.getContext());
        for (int i = 0; i < contextRef.size() && i < newRef.size(); ++i) {
            if (NAME_WILDCARD.equals(newRef.getName(i)) && !NAME_WILDCARD.equals(contextRef.getName(i))) {
                newRef.data.set(i, newRef.data.get(i).setName(contextRef.getName(i)));
            }
            if (!contextRef.getName(i).equals(newRef.getName(i))) break;
            if (newRef.getPredicate(i) == null) {
                List<XPathExpression> predicate = contextRef.getPredicate(i);
                newRef.addPredicate(i, predicate);
            }
            if (i + this.refLevel > newRef.size()) continue;
            int multiplicity = contextRef.getMultiplicity(i);
            newRef.setMultiplicity(i, multiplicity);
        }
        return newRef;
    }

    public TreeReference relativize(TreeReference parent) {
        if (parent.isParentOf(this, false)) {
            TreeReference relRef = TreeReference.selfRef();
            for (int i = parent.size(); i < this.size(); ++i) {
                relRef.add(this.getName(i), -1);
            }
            return relRef;
        }
        return null;
    }

    public TreeReference genericize() {
        TreeReference genericRef = this.clone();
        for (int i = 0; i < genericRef.size(); ++i) {
            genericRef.setMultiplicity(i, -1);
        }
        return genericRef;
    }

    public boolean isParentOf(TreeReference child, boolean properParent) {
        if (this.refLevel != child.refLevel) {
            return false;
        }
        if (child.size() < this.size() + (properParent ? 1 : 0)) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getName(i).equals(child.getName(i))) {
                return false;
            }
            int parMult = this.getMultiplicity(i);
            int childMult = child.getMultiplicity(i);
            if (parMult == -1 || parMult == childMult || i == 0 && parMult == 0 && childMult == -1) continue;
            return false;
        }
        return true;
    }

    public TreeReference extendRef(String name, int mult) {
        TreeReference childRef = this.clone();
        childRef.add(name, mult);
        return childRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TreeReference) {
            TreeReference ref = (TreeReference)o;
            if (this.refLevel == ref.refLevel && this.size() == ref.size()) {
                for (int i = 0; i < this.size(); ++i) {
                    String nameA = this.getName(i);
                    String nameB = ref.getName(i);
                    int multA = this.getMultiplicity(i);
                    int multB = ref.getMultiplicity(i);
                    List<XPathExpression> predA = this.getPredicate(i);
                    List<XPathExpression> predB = ref.getPredicate(i);
                    if (!nameA.equals(nameB)) {
                        return false;
                    }
                    if (multA != multB) {
                        if (!(i != 0 || multA != 0 && multA != -1 || multB != 0 && multB != -1)) continue;
                        return false;
                    }
                    if (predA != null && predB != null) {
                        if (predA.size() != predB.size()) {
                            return false;
                        }
                        for (int j = 0; j < predA.size(); ++j) {
                            if (predA.get(j).equals(predB.get(j))) continue;
                            return false;
                        }
                        continue;
                    }
                    if ((predA != null || predB == null) && (predA == null || predB != null)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int hash = Integer.valueOf(this.refLevel).hashCode();
        for (int i = 0; i < this.size(); ++i) {
            Integer mult = DataUtil.integer(this.getMultiplicity(i));
            if (i == 0 && mult == -1) {
                mult = DataUtil.integer(0);
            }
            hash ^= this.getName(i).hashCode();
            hash ^= mult.hashCode();
            List<XPathExpression> predicates = this.getPredicate(i);
            if (predicates == null) continue;
            int val = 0;
            for (XPathExpression xpe : predicates) {
                hash ^= val;
                hash ^= xpe.hashCode();
                ++val;
            }
        }
        return hash;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includePredicates) {
        return this.toString(includePredicates, false);
    }

    public String toString(boolean includePredicates, boolean zeroIndexMult) {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.instanceName != null) {
            sb.append("instance(" + this.instanceName + ")");
        } else if (this.contextType == 2) {
            sb.append("current()");
        } else if (this.contextType == 1) {
            sb.append("inherited()");
        }
        if (this.isAbsolute()) {
            sb.append("/");
        } else {
            for (i = 0; i < this.refLevel; ++i) {
                sb.append("../");
            }
        }
        for (i = 0; i < this.size(); ++i) {
            String name = this.getName(i);
            int mult = this.getMultiplicity(i);
            if (mult == -4) {
                sb.append("@");
            }
            sb.append(name);
            if (includePredicates) {
                switch (mult) {
                    case -1: {
                        break;
                    }
                    case -2: {
                        sb.append("[@template]");
                        break;
                    }
                    case -10: {
                        sb.append("[@juncture]");
                        break;
                    }
                    default: {
                        if (i <= 0 && mult == 0 || mult == -4) break;
                        sb.append("[").append(mult + (zeroIndexMult ? 0 : 1)).append("]");
                    }
                }
            }
            if (i >= this.size() - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < this.size(); ++i) {
            int mult = this.getMultiplicity(i);
            switch (mult) {
                case -1: {
                    continue block5;
                }
                case -2: {
                    sb.append("[@template]");
                    continue block5;
                }
                case -10: {
                    sb.append("[@juncture]");
                    continue block5;
                }
                default: {
                    if (i <= 0 && mult == 0 || mult == -4) continue block5;
                    if (sb.length() > 0) {
                        sb.append("_");
                    }
                    sb.append(mult + 1);
                }
            }
        }
        return this.getNameLast() + " [" + sb.toString() + "]";
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.refLevel = ExtUtil.readInt(in);
        this.instanceName = (String)ExtUtil.read(in, new ExtWrapNullable(String.class), pf);
        this.contextType = ExtUtil.readInt(in);
        int size = ExtUtil.readInt(in);
        for (int i = 0; i < size; ++i) {
            TreeReferenceLevel level = (TreeReferenceLevel)ExtUtil.read(in, TreeReferenceLevel.class);
            this.add(level.intern());
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeNumeric(out, this.refLevel);
        ExtUtil.write(out, new ExtWrapNullable(this.instanceName));
        ExtUtil.writeNumeric(out, this.contextType);
        ExtUtil.writeNumeric(out, this.size());
        for (TreeReferenceLevel l : this.data) {
            ExtUtil.write(out, l);
        }
    }

    public TreeReference intersect(TreeReference b) {
        TreeReference a;
        if (!this.isAbsolute() || !b.isAbsolute()) {
            return TreeReference.rootRef();
        }
        if (this.equals(b)) {
            return this;
        }
        if (this.size() < b.size()) {
            a = b.clone();
            b = this.clone();
        } else {
            a = this.clone();
            b = b.clone();
        }
        int diff = a.size() - b.size();
        for (int i = 0; i < diff; ++i) {
            a.removeLastLevel();
        }
        int aSize = a.size();
        for (int i = 0; i <= aSize; ++i) {
            if (a.equals(b)) {
                return a;
            }
            if (a.size() == 0) {
                return TreeReference.rootRef();
            }
            if (a.removeLastLevel() && b.removeLastLevel()) continue;
            throw new RuntimeException("Dug too deply into TreeReference during intersection");
        }
        throw new RuntimeException("Impossible state");
    }

    public void setContext(int context) {
        this.contextType = context;
    }

    public int getContext() {
        return this.contextType;
    }

    public TreeReference getSubReference(int level) {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("Cannot subreference a non-absolute ref");
        }
        TreeReference ret = new TreeReference();
        ret.refLevel = this.refLevel;
        ret.contextType = this.contextType;
        ret.instanceName = this.instanceName;
        ret.data = new ArrayList<TreeReferenceLevel>(level);
        for (int i = 0; i <= level; ++i) {
            ret.data.add(this.data.get(i));
        }
        return ret;
    }

    public boolean hasPredicates() {
        for (TreeReferenceLevel level : this.data) {
            if (level.getPredicates() == null) continue;
            return true;
        }
        return false;
    }

    public TreeReference removePredicates() {
        TreeReference predicateless = this.clone();
        for (int i = 0; i < predicateless.data.size(); ++i) {
            predicateless.data.set(i, predicateless.data.get(i).setPredicates(null));
        }
        return predicateless;
    }
}

