/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.reference;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.reference.ReferenceManager;
import org.javarosa.core.services.locale.LocaleDataSource;
import org.javarosa.core.services.locale.LocalizationUtils;
import org.javarosa.core.util.OrderedMap;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceDataSource
implements LocaleDataSource {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceDataSource.class);
    String referenceURI;

    public ReferenceDataSource() {
    }

    public ReferenceDataSource(String referenceURI) {
        if (referenceURI == null) {
            throw new NullPointerException("Reference URI cannot be null when creating a Resource File Data Source");
        }
        this.referenceURI = referenceURI;
    }

    @Override
    public OrderedMap<String, String> getLocalizedText() {
        try {
            InputStream is = ReferenceManager.instance().deriveReference(this.referenceURI).getStream();
            return LocalizationUtils.parseLocaleInput(is);
        }
        catch (IOException e) {
            logger.error("Error", (Throwable)e);
            throw new RuntimeException("IOException while getting localized text at reference " + this.referenceURI);
        }
        catch (InvalidReferenceException e) {
            logger.error("Error", (Throwable)e);
            throw new RuntimeException("Invalid Reference! " + this.referenceURI);
        }
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.referenceURI = in.readUTF();
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        out.writeUTF(this.referenceURI);
    }
}

