/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.transport.payload;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.javarosa.core.data.IDataPointer;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.core.services.transport.payload.IDataPayloadVisitor;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class DataPointerPayload
implements IDataPayload {
    IDataPointer pointer;

    public DataPointerPayload() {
    }

    public DataPointerPayload(IDataPointer pointer) {
        this.pointer = pointer;
    }

    @Override
    public <T> T accept(IDataPayloadVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public long getLength() {
        return this.pointer.getLength();
    }

    @Override
    public String getPayloadId() {
        return this.pointer.getDisplayText();
    }

    @Override
    public InputStream getPayloadStream() throws IOException {
        return this.pointer.getDataStream();
    }

    @Override
    public int getPayloadType() {
        String display = this.pointer.getDisplayText();
        if (display == null || display.lastIndexOf(46) == -1) {
            return 0;
        }
        String ext = display.substring(display.lastIndexOf(46) + 1);
        if (ext.equals("jpg") || ext.equals("jpeg")) {
            return 2;
        }
        return 2;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.pointer = (IDataPointer)ExtUtil.read(in, new ExtWrapTagged());
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapTagged(this.pointer));
    }

    @Override
    public int getTransportId() {
        return -1;
    }
}

