/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javarosa.core.util.DataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheTable<K> {
    private static final Logger logger = LoggerFactory.getLogger(CacheTable.class);
    int totalAdditions = 0;
    private Hashtable<Integer, WeakReference<Object>> currentTable = new Hashtable();
    private static Vector<WeakReference<CacheTable<?>>> caches = new Vector(1);
    private static Thread cleaner = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Vector<Integer> toRemove = new Vector<Integer>();
            block10: while (true) {
                try {
                    while (true) {
                        toRemove.removeAllElements();
                        for (int i = 0; i < caches.size(); ++i) {
                            CacheTable cache = (CacheTable)((WeakReference)caches.elementAt(i)).get();
                            if (cache == null) {
                                toRemove.addElement(DataUtil.integer(i));
                                continue;
                            }
                            Hashtable table = cache.currentTable;
                            Enumeration en = table.keys();
                            while (en.hasMoreElements()) {
                                Integer key = (Integer)en.nextElement();
                                CacheTable cacheTable = cache;
                                synchronized (cacheTable) {
                                    if (((WeakReference)table.get(key)).get() == null) {
                                        table.remove(key);
                                    }
                                }
                            }
                            CacheTable cacheTable = cache;
                            synchronized (cacheTable) {
                                if (cache.totalAdditions > 50 && cache.totalAdditions - cache.currentTable.size() > cache.currentTable.size() >> 2) {
                                    Hashtable newTable = new Hashtable(cache.currentTable.size());
                                    int oldMax = cache.totalAdditions;
                                    Enumeration en2 = table.keys();
                                    while (en2.hasMoreElements()) {
                                        Integer key = (Integer)en2.nextElement();
                                        newTable.put(key, cache.currentTable.get(key));
                                    }
                                    cache.currentTable = newTable;
                                    cache.totalAdditions = cache.currentTable.size();
                                }
                                continue;
                            }
                        }
                        for (int id = toRemove.size() - 1; id >= 0; --id) {
                            caches.removeElementAt((Integer)toRemove.elementAt(id));
                        }
                        try {
                            Thread.sleep(3000L);
                            continue block10;
                        }
                        catch (InterruptedException e) {
                            logger.error("Error", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    logger.error("Error", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerCache(CacheTable<?> table) {
        caches.addElement(new WeakReference(table));
        Thread thread = cleaner;
        synchronized (thread) {
            if (!cleaner.isAlive()) {
                cleaner.start();
            }
        }
    }

    public CacheTable() {
        CacheTable.registerCache(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K intern(K k) {
        CacheTable cacheTable = this;
        synchronized (cacheTable) {
            int hash = k.hashCode();
            K nk = this.retrieve(hash);
            if (nk == null) {
                this.register(hash, k);
                return k;
            }
            if (k.equals(nk)) {
                return nk;
            }
            return k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K retrieve(int key) {
        CacheTable cacheTable = this;
        synchronized (cacheTable) {
            if (!this.currentTable.containsKey(DataUtil.integer(key))) {
                return null;
            }
            Object retVal = this.currentTable.get(DataUtil.integer(key)).get();
            if (retVal == null) {
                this.currentTable.remove(DataUtil.integer(key));
            }
            return (K)retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(int key, K item) {
        CacheTable cacheTable = this;
        synchronized (cacheTable) {
            this.currentTable.put(DataUtil.integer(key), new WeakReference<K>(item));
            ++this.totalAdditions;
        }
    }
}

