/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.javarosa.core.util.Map;
import org.javarosa.core.util.OrderedMap;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapBase;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapMap
extends ExternalizableWrapper {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_ORDERED = 1;
    public static final int TYPE_SLOW_COMPACT = 2;
    public static final int TYPE_SLOW_READ_ONLY = 4;
    public ExternalizableWrapper keyType;
    public ExternalizableWrapper dataType;
    public int type;

    public ExtWrapMap(HashMap val) {
        this(val, null, null);
    }

    public ExtWrapMap(HashMap val, ExternalizableWrapper dataType) {
        this(val, null, dataType);
    }

    public ExtWrapMap(java.util.Map val, ExternalizableWrapper keyType, ExternalizableWrapper dataType) {
        if (val == null) {
            throw new NullPointerException();
        }
        this.val = val;
        this.keyType = keyType;
        this.dataType = dataType;
        this.type = val instanceof Map ? 4 : (val instanceof OrderedMap ? 1 : 0);
    }

    public ExtWrapMap() {
    }

    public ExtWrapMap(Class keyType, Class dataType) {
        this(keyType, dataType, 0);
    }

    public ExtWrapMap(Class keyType, ExternalizableWrapper dataType) {
        this(keyType, dataType, 0);
    }

    public ExtWrapMap(ExternalizableWrapper keyType, ExternalizableWrapper dataType) {
        this(keyType, dataType, 0);
    }

    public ExtWrapMap(Class keyType, Class dataType, int type) {
        this(new ExtWrapBase(keyType), (ExternalizableWrapper)new ExtWrapBase(dataType), type);
    }

    public ExtWrapMap(Class keyType, ExternalizableWrapper dataType, int type) {
        this(new ExtWrapBase(keyType), dataType, type);
    }

    public ExtWrapMap(ExternalizableWrapper keyType, ExternalizableWrapper dataType, int type) {
        if (keyType == null || dataType == null) {
            throw new NullPointerException();
        }
        this.keyType = keyType;
        this.dataType = dataType;
        this.type = type;
    }

    @Override
    public ExternalizableWrapper clone(Object val) {
        return new ExtWrapMap((HashMap)val, this.keyType, this.dataType);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        if (this.type != 4) {
            HashMap h;
            long size = ExtUtil.readNumeric(in);
            switch (this.type) {
                case 0: {
                    h = new HashMap((int)size);
                    break;
                }
                case 1: {
                    h = new OrderedMap();
                    break;
                }
                case 2: {
                    h = new Map((int)size);
                    break;
                }
                default: {
                    h = new HashMap((int)size);
                }
            }
            int i = 0;
            while ((long)i < size) {
                Object key = ExtUtil.read(in, this.keyType, pf);
                Object elem = ExtUtil.read(in, this.dataType, pf);
                h.put(key, elem);
                ++i;
            }
            this.val = h;
        } else {
            int size = ExtUtil.readInt(in);
            Object[] k = new Object[size];
            Object[] v = new Object[size];
            for (int i = 0; i < size; ++i) {
                k[i] = ExtUtil.read(in, this.keyType, pf);
                v[i] = ExtUtil.read(in, this.dataType, pf);
            }
            this.val = new Map<Object, Object>(k, v);
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        HashMap h = (HashMap)this.val;
        ExtUtil.writeNumeric(out, h.size());
        for (Object key : h.keySet()) {
            Object elem = h.get(key);
            ExtUtil.write(out, this.keyType == null ? key : this.keyType.clone(key));
            ExtUtil.write(out, this.dataType == null ? elem : this.dataType.clone(elem));
        }
    }

    @Override
    public void metaReadExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.type = ExtUtil.readInt(in);
        this.keyType = ExtWrapTagged.readTag(in, pf);
        this.dataType = ExtWrapTagged.readTag(in, pf);
    }

    @Override
    public void metaWriteExternal(DataOutputStream out) throws IOException {
        ExternalizableWrapper keyTagObj;
        HashMap h = (HashMap)this.val;
        Object object = this.keyType == null ? (h.size() == 0 ? new Object() : h.keySet().iterator().next()) : (keyTagObj = this.keyType);
        ExternalizableWrapper elemTagObj = this.dataType == null ? (h.size() == 0 ? new Object() : h.values().iterator().next()) : this.dataType;
        ExtUtil.writeNumeric(out, this.type);
        ExtWrapTagged.writeTag(out, keyTagObj);
        ExtWrapTagged.writeTag(out, elemTagObj);
    }
}

