/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.model.xform;

import java.io.IOException;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IAnswerDataSerializer;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.utils.IInstanceSerializingVisitor;
import org.javarosa.core.services.transport.payload.ByteArrayPayload;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.model.xform.XFormSerializingVisitor;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.util.XFormAnswerDataSerializer;
import org.kxml2.kdom.Element;

public class CompactSerializingVisitor
implements IInstanceSerializingVisitor {
    private String resultText = "";
    private String delimiter;
    private IAnswerDataSerializer serializer;

    @Override
    public byte[] serializeInstance(FormInstance model, FormDef formDef) throws IOException {
        return this.serializeInstance(model);
    }

    @Override
    public byte[] serializeInstance(FormInstance model) throws IOException {
        return this.serializeInstance(model, new XPathReference("/"));
    }

    @Override
    public byte[] serializeInstance(FormInstance model, IDataReference ref) throws IOException {
        if (this.serializer == null) {
            this.setAnswerDataSerializer(new XFormAnswerDataSerializer());
        }
        model.accept(this);
        if (this.resultText != null) {
            return this.resultText.getBytes("UTF-16BE");
        }
        return null;
    }

    @Override
    public IDataPayload createSerializedPayload(FormInstance model) throws IOException {
        return this.createSerializedPayload(model, new XPathReference("/"));
    }

    @Override
    public IDataPayload createSerializedPayload(FormInstance model, IDataReference ref) throws IOException {
        if (this.serializer == null) {
            this.setAnswerDataSerializer(new XFormAnswerDataSerializer());
        }
        model.accept(this);
        if (this.resultText != null) {
            byte[] form = this.resultText.getBytes("UTF-8");
            return new ByteArrayPayload(form, null, 5);
        }
        return null;
    }

    @Override
    public void visit(FormInstance tree) {
        TreeElement root = tree.getRoot();
        this.delimiter = root.getAttributeValue("http://www.opendatakit.org/xforms", "delimiter");
        String prefix = root.getAttributeValue("http://www.opendatakit.org/xforms", "prefix");
        String string = this.delimiter = this.delimiter != null ? this.delimiter : " ";
        if (prefix != null) {
            this.resultText = prefix.concat(this.delimiter);
        }
        this.resultText = this.resultText.concat(this.serializeTreeToString(root));
    }

    private String serializeTreeToString(TreeElement root) {
        StringBuilder sb = new StringBuilder();
        this.serializeTree(root, sb);
        return sb.toString().trim();
    }

    private void serializeTree(TreeElement root, StringBuilder sb) {
        for (int j = 0; j < root.getNumChildren(); ++j) {
            TreeElement treeElement = root.getChildAt(j);
            if (treeElement.isLeaf() && treeElement.getAttribute("http://www.opendatakit.org/xforms", "tag") != null) {
                String result = this.serializeNode(treeElement);
                if (result == null) continue;
                sb.append(result);
                continue;
            }
            this.serializeTree(treeElement, sb);
        }
    }

    public String serializeNode(TreeElement instanceNode) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!instanceNode.isRelevant() || instanceNode.getMult() == -2) {
            return null;
        }
        if (instanceNode.getValue() != null) {
            Object serializedAnswer = this.serializer.serializeAnswerData(instanceNode.getValue(), instanceNode.getDataType());
            if (serializedAnswer instanceof Element) {
                throw new RuntimeException("Can't handle serialized output for " + instanceNode.getValue().toString() + ", " + serializedAnswer);
            }
            if (serializedAnswer instanceof String) {
                Element element = new Element();
                element.addChild(4, serializedAnswer);
                String tag = instanceNode.getAttributeValue("http://www.opendatakit.org/xforms", "tag");
                stringBuilder.append(tag);
                stringBuilder.append(this.delimiter);
                for (int k = 0; k < element.getChildCount(); ++k) {
                    stringBuilder.append(element.getChild(k).toString().replace("\\", "\\\\").replace(this.delimiter, "\\" + this.delimiter));
                    stringBuilder.append(this.delimiter);
                }
            } else {
                throw new RuntimeException("Can't handle serialized output for " + instanceNode.getValue().toString() + ", " + serializedAnswer);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setAnswerDataSerializer(IAnswerDataSerializer ads) {
        this.serializer = ads;
    }

    @Override
    public IInstanceSerializingVisitor newInstance() {
        XFormSerializingVisitor modelSerializer = new XFormSerializingVisitor();
        modelSerializer.setAnswerDataSerializer(this.serializer);
        return modelSerializer;
    }
}

