/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.parse;

import java.util.Collection;
import java.util.Map;
import org.javarosa.core.model.DataBinding;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.condition.Condition;
import org.javarosa.core.model.condition.Recalculate;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.parse.IXFormParserFunctions;
import org.javarosa.xform.parse.XFormParseException;
import org.javarosa.xpath.XPathConditional;
import org.javarosa.xpath.XPathException;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.kxml2.kdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandardBindAttributesProcessor {
    private static final Logger logger = LoggerFactory.getLogger(StandardBindAttributesProcessor.class);
    private Map<String, Integer> typeMappings;

    StandardBindAttributesProcessor(Map<String, Integer> typeMappings) {
        this.typeMappings = typeMappings;
    }

    DataBinding createBinding(IXFormParserFunctions parserFunctions, FormDef formDef, Collection<String> usedAttributes, Collection<String> passedThroughAttributes, Element element) {
        String xpathCalc;
        String xpathConstr;
        String xpathRO;
        String xpathReq;
        IDataReference ref;
        DataBinding binding = new DataBinding();
        binding.setId(element.getAttributeValue("", "id"));
        String nodeset = element.getAttributeValue(null, "nodeset");
        if (nodeset == null) {
            throw new XFormParseException("XForm Parse: <bind> without nodeset", element);
        }
        try {
            ref = new XPathReference(nodeset);
        }
        catch (XPathException xpe) {
            throw new XFormParseException(xpe.getMessage());
        }
        ref = parserFunctions.getAbsRef(ref, formDef);
        binding.setReference(ref);
        binding.setDataType(this.getDataType(element.getAttributeValue(null, "type")));
        String xpathRel = element.getAttributeValue(null, "relevant");
        if (xpathRel != null) {
            if ("true()".equals(xpathRel)) {
                binding.relevantAbsolute = true;
            } else if ("false()".equals(xpathRel)) {
                binding.relevantAbsolute = false;
            } else {
                Condition c = this.buildCondition(xpathRel, "relevant", ref);
                binding.relevancyCondition = c = (Condition)formDef.addTriggerable(c);
            }
        }
        if ((xpathReq = element.getAttributeValue(null, "required")) != null) {
            if ("true()".equals(xpathReq)) {
                binding.requiredAbsolute = true;
            } else if ("false()".equals(xpathReq)) {
                binding.requiredAbsolute = false;
            } else {
                Condition c = this.buildCondition(xpathReq, "required", ref);
                binding.requiredCondition = c = (Condition)formDef.addTriggerable(c);
            }
        }
        if ((xpathRO = element.getAttributeValue(null, "readonly")) != null) {
            if ("true()".equals(xpathRO)) {
                binding.readonlyAbsolute = true;
            } else if ("false()".equals(xpathRO)) {
                binding.readonlyAbsolute = false;
            } else {
                Condition c = this.buildCondition(xpathRO, "readonly", ref);
                binding.readonlyCondition = c = (Condition)formDef.addTriggerable(c);
            }
        }
        if ((xpathConstr = element.getAttributeValue(null, "constraint")) != null) {
            try {
                binding.constraint = new XPathConditional(xpathConstr);
            }
            catch (XPathSyntaxException xse) {
                throw new XFormParseException("bind for " + nodeset + " contains invalid constraint expression [" + xpathConstr + "] " + xse.getMessage());
            }
            binding.constraintMessage = element.getAttributeValue("http://openrosa.org/javarosa", "constraintMsg");
        }
        if ((xpathCalc = element.getAttributeValue(null, "calculate")) != null) {
            Recalculate r;
            try {
                r = this.buildCalculate(xpathCalc, ref);
            }
            catch (XPathSyntaxException xpse) {
                throw new XFormParseException("Invalid calculate for the bind attached to \"" + nodeset + "\" : " + xpse.getMessage() + " in expression " + xpathCalc);
            }
            binding.calculate = r = (Recalculate)formDef.addTriggerable(r);
        }
        binding.setPreload(element.getAttributeValue("http://openrosa.org/javarosa", "preload"));
        binding.setPreloadParams(element.getAttributeValue("http://openrosa.org/javarosa", "preloadParams"));
        this.saveUnusedAttributes(binding, element, usedAttributes, passedThroughAttributes);
        return binding;
    }

    private Condition buildCondition(String xpath, String type, IDataReference contextRef) {
        XPathConditional xPathConditional;
        int falseAction;
        int trueAction;
        String prettyType;
        switch (type) {
            case "relevant": {
                prettyType = "display";
                trueAction = 1;
                falseAction = 2;
                break;
            }
            case "required": {
                prettyType = "require";
                trueAction = 7;
                falseAction = 8;
                break;
            }
            case "readonly": {
                prettyType = "readonly";
                trueAction = 4;
                falseAction = 3;
                break;
            }
            default: {
                throw new XFormParseException("Unsupported type " + type + " passed to buildCondition");
            }
        }
        try {
            xPathConditional = new XPathConditional(xpath);
        }
        catch (XPathSyntaxException xse) {
            logger.error("XForm Parse Error: Encountered a problem with {} condition for node [{}] at line: {}{}", new Object[]{prettyType, contextRef.getReference().toString(), xpath, xse.getMessage()});
            throw new XFormParseException("Encountered a problem with " + prettyType + " condition for node [" + contextRef.getReference().toString() + "] at line: " + xpath + ", " + xse.getMessage());
        }
        return new Condition(xPathConditional, trueAction, falseAction, FormInstance.unpackReference(contextRef));
    }

    private Recalculate buildCalculate(String xpath, IDataReference contextRef) throws XPathSyntaxException {
        return new Recalculate(new XPathConditional(xpath), FormInstance.unpackReference(contextRef));
    }

    private int getDataType(String type) {
        int dataType = 0;
        if (type != null) {
            if (type.contains(":")) {
                type = type.substring(type.indexOf(":") + 1);
            }
            if (this.typeMappings.containsKey(type)) {
                dataType = this.typeMappings.get(type);
            } else {
                dataType = -1;
                logger.warn("XForm Parse Warning: unrecognized data type [{}]", (Object)type);
            }
        }
        return dataType;
    }

    private void saveUnusedAttributes(DataBinding binding, Element element, Collection<String> usedAttributes, Collection<String> passedThroughAttributes) {
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            String name = element.getAttributeName(i);
            if (usedAttributes.contains(name) && !passedThroughAttributes.contains(name)) continue;
            binding.setAdditionalAttribute(element.getAttributeNamespace(i), name, element.getAttributeValue(i));
        }
    }
}

