/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.xml.ElementParser;
import org.javarosa.xml.TreeElementParser;
import org.javarosa.xml.util.InvalidStructureException;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class InternalDataInstanceParser {
    public static HashMap<String, DataInstance> buildInstances(String xFormSrc) {
        HashMap<String, DataInstance> internalDataInstances = new HashMap<String, DataInstance>();
        try {
            FileInputStream inputStream = new FileInputStream(xFormSrc);
            KXmlParser parser = ElementParser.instantiateParser(inputStream);
            TreeElementParser treeElementParser = new TreeElementParser(parser, 0, "");
            List<TreeElement> internalInstancesTreeElementList = treeElementParser.parseInternalSecondaryInstances();
            for (TreeElement treeElement : internalInstancesTreeElementList) {
                String id = treeElement.getAttribute(null, "id").getAttributeValue();
                FormInstance internalDataInstance = new FormInstance(treeElement.getChildAt(0), id);
                internalDataInstances.put(internalDataInstance.getInstanceId(), internalDataInstance);
            }
        }
        catch (IOException | InvalidStructureException | XmlPullParserException e) {
            e.printStackTrace();
        }
        return internalDataInstances;
    }
}

