/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.util.List;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.xpath.XPathException;
import org.javarosa.xpath.XPathMissingInstanceException;
import org.javarosa.xpath.XPathNodeset;

public class XPathPathExprEval {
    public XPathNodeset eval(TreeReference reference, EvaluationContext ec) {
        TreeReference ref = this.getContextualizedTreeReference(reference, ec);
        DataInstance dataInstance = this.getDataInstance(ec, ref);
        List<TreeReference> nodesetRefs = ec.expandReference(ref);
        this.removeIrrelevantNodesets(dataInstance, nodesetRefs);
        return new XPathNodeset(nodesetRefs, dataInstance, ec);
    }

    private void removeIrrelevantNodesets(DataInstance dataInstance, List<TreeReference> nodesetRefs) {
        for (int i = 0; i < nodesetRefs.size(); ++i) {
            if (dataInstance.resolveReference(nodesetRefs.get(i)).isRelevant()) continue;
            nodesetRefs.remove(i);
            --i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataInstance getDataInstance(EvaluationContext ec, TreeReference ref) {
        DataInstance dataInstance;
        if (this.refersToNonMainInstance(ref)) {
            DataInstance nonMainInstance = ec.getInstance(ref.getInstanceName());
            if (nonMainInstance == null) throw new XPathMissingInstanceException(ref.getInstanceName(), "Instance referenced by " + ref.toString(true) + " does not exist");
            dataInstance = nonMainInstance;
        } else {
            dataInstance = ec.getMainInstance();
            if (dataInstance == null) {
                throw new XPathException("Cannot evaluate the reference [" + ref.toString(true) + "] in the current evaluation context. No default instance has been declared!");
            }
        }
        if (dataInstance.getRoot() != null) return dataInstance;
        throw new XPathMissingInstanceException(ref.getInstanceName(), "Instance referenced by " + ref.toString(true) + " has not been loaded");
    }

    private boolean refersToNonMainInstance(TreeReference ref) {
        return ref.getInstanceName() != null && ref.isAbsolute();
    }

    private TreeReference getContextualizedTreeReference(TreeReference genericRef, EvaluationContext ec) {
        TreeReference contextRef = genericRef.getContext() == 2 ? ec.getOriginalContext() : ec.getContextRef();
        return genericRef.contextualize(contextRef);
    }
}

